/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.spi.indexing.h2;

import org.gridgain.grid.spi.GridSpiManagementMBean;
import org.gridgain.grid.util.mbean.GridMBeanDescription;
import org.gridgain.grid.util.mbean.GridMBeanParametersDescriptions;
import org.gridgain.grid.util.mbean.GridMBeanParametersNames;
import org.jetbrains.annotations.Nullable;

@GridMBeanDescription(value="MBean that provides access to H2 indexing SPI configuration.")
public interface GridH2IndexingSpiMBean
extends GridSpiManagementMBean {
    @GridMBeanDescription(value="Index primitive key-value pairs by key by default in all schemas.")
    public boolean isDefaultIndexPrimitiveKey();

    @GridMBeanDescription(value="Index primitive key-value pairs by value by default in all schemas.")
    public boolean isDefaultIndexPrimitiveValue();

    @GridMBeanDescription(value="If false, SPI will store all keys in BINARY form, otherwise it will try to convert key type to respective SQL type.")
    public boolean isDefaultIndexFixedTyping();

    @GridMBeanDescription(value="Maximum off-heap memory for indexes.")
    public long getMaxOffHeapMemory();

    @GridMBeanDescription(value="Index write lock wait time in milliseconds.")
    public long getIndexWriteLockWaitTime();

    @GridMBeanDescription(value="Maximum allowed off-heap rows cache size.")
    public int getMaxOffheapRowsCacheSize();

    @GridMBeanDescription(value="Current off-heap rows cache size.")
    public int getOffheapRowsCacheSize();

    @GridMBeanDescription(value="Allocated off-heap memory for indexes.")
    public long getAllocatedOffHeapMemory();

    @GridMBeanDescription(value="All registered in this SPI spaces.")
    public String getSpaceNames();

    @Nullable
    public String[] getSearchPath();

    @Nullable
    public String getInitialScriptPath();

    @GridMBeanDescription(value="Query execution time interpreted by SPI as long query.")
    public long getLongQueryExecutionTimeout();

    @GridMBeanDescription(value="If true, SPI will print SQL execution plan for long queries (explain SQL query).")
    public boolean isLongQueryExplain();

    @GridMBeanDescription(value="Index by key entries where key and value are primitive types in given space.")
    @GridMBeanParametersNames(value={"spaceName"})
    @GridMBeanParametersDescriptions(value={"Space name."})
    public boolean isIndexPrimitiveKey(@Nullable String var1);

    @GridMBeanDescription(value="Index by value entries where key and value are primitive types in given space.")
    @GridMBeanParametersNames(value={"spaceName"})
    @GridMBeanParametersDescriptions(value={"Space name."})
    public boolean isIndexPrimitiveValue(@Nullable String var1);

    @GridMBeanDescription(value="If false, SPI will store all keys in BINARY form, otherwise it will try to convert key type to respective SQL type.")
    @GridMBeanParametersNames(value={"spaceName"})
    @GridMBeanParametersDescriptions(value={"Space name."})
    public boolean isIndexFixedTyping(@Nullable String var1);
}

