/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.spi.indexing.h2;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridInterruptedException;
import org.gridgain.grid.GridRuntimeException;
import org.gridgain.grid.cache.query.GridCacheQuerySqlFunction;
import org.gridgain.grid.kernal.processors.cache.GridCacheSwapEntry;
import org.gridgain.grid.lang.GridBiTuple;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.marshaller.GridMarshaller;
import org.gridgain.grid.resources.GridLocalNodeIdResource;
import org.gridgain.grid.resources.GridLoggerResource;
import org.gridgain.grid.resources.GridMarshallerResource;
import org.gridgain.grid.spi.GridSpiAdapter;
import org.gridgain.grid.spi.GridSpiCloseableIterator;
import org.gridgain.grid.spi.GridSpiConfiguration;
import org.gridgain.grid.spi.GridSpiContext;
import org.gridgain.grid.spi.GridSpiException;
import org.gridgain.grid.spi.GridSpiMultipleInstancesSupport;
import org.gridgain.grid.spi.indexing.GridIndexDescriptor;
import org.gridgain.grid.spi.indexing.GridIndexType;
import org.gridgain.grid.spi.indexing.GridIndexingEntity;
import org.gridgain.grid.spi.indexing.GridIndexingEntityAdapter;
import org.gridgain.grid.spi.indexing.GridIndexingFieldMetadata;
import org.gridgain.grid.spi.indexing.GridIndexingFieldsResult;
import org.gridgain.grid.spi.indexing.GridIndexingFieldsResultAdapter;
import org.gridgain.grid.spi.indexing.GridIndexingKeyValueRow;
import org.gridgain.grid.spi.indexing.GridIndexingKeyValueRowAdapter;
import org.gridgain.grid.spi.indexing.GridIndexingMarshaller;
import org.gridgain.grid.spi.indexing.GridIndexingQueryFilter;
import org.gridgain.grid.spi.indexing.GridIndexingSpi;
import org.gridgain.grid.spi.indexing.GridIndexingTypeDescriptor;
import org.gridgain.grid.spi.indexing.h2.GridH2IndexingSpaceConfiguration;
import org.gridgain.grid.spi.indexing.h2.GridH2IndexingSpiMBean;
import org.gridgain.grid.spi.indexing.h2.GridH2ResultSetIterator;
import org.gridgain.grid.spi.indexing.h2.opt.GridH2AbstractKeyValueRow;
import org.gridgain.grid.spi.indexing.h2.opt.GridH2IndexBase;
import org.gridgain.grid.spi.indexing.h2.opt.GridH2KeyValueRowOffheap;
import org.gridgain.grid.spi.indexing.h2.opt.GridH2KeyValueRowOnheap;
import org.gridgain.grid.spi.indexing.h2.opt.GridH2RowDescriptor;
import org.gridgain.grid.spi.indexing.h2.opt.GridH2SpatialIndex;
import org.gridgain.grid.spi.indexing.h2.opt.GridH2Table;
import org.gridgain.grid.spi.indexing.h2.opt.GridH2TreeIndex;
import org.gridgain.grid.spi.indexing.h2.opt.GridLuceneIndex;
import org.gridgain.grid.spi.swapspace.GridSwapKey;
import org.gridgain.grid.util.GridConcurrentHashSet;
import org.gridgain.grid.util.GridEmptyCloseableIterator;
import org.gridgain.grid.util.GridStringBuilder;
import org.gridgain.grid.util.future.GridFutureAdapterEx;
import org.gridgain.grid.util.offheap.unsafe.GridUnsafeMemory;
import org.gridgain.grid.util.typedef.F;
import org.gridgain.grid.util.typedef.T2;
import org.gridgain.grid.util.typedef.X;
import org.gridgain.grid.util.typedef.internal.A;
import org.gridgain.grid.util.typedef.internal.LT;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.SB;
import org.gridgain.grid.util.typedef.internal.U;
import org.h2.api.JavaObjectSerializer;
import org.h2.command.CommandInterface;
import org.h2.constant.SysProperties;
import org.h2.index.Index;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.message.DbException;
import org.h2.mvstore.cache.CacheLongKeyLIRS;
import org.h2.server.Service;
import org.h2.server.web.WebServer;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.tools.Server;
import org.h2.util.StringUtils;
import org.h2.value.DataType;
import org.jdk8.backport.ConcurrentHashMap8;
import org.jetbrains.annotations.Nullable;

@GridSpiMultipleInstancesSupport(value=true)
public class GridH2IndexingSpi
extends GridSpiAdapter
implements GridIndexingSpi,
GridH2IndexingSpiMBean {
    public static final long DFLT_LONG_QRY_EXEC_TIMEOUT = 3000L;
    private static final long DFLT_IDX_WRITE_LOCK_WAIT_TIME = 100L;
    private static final String DFLT_DB_NAME = "gridgain_indexes";
    private static final String DFLT_DB_OPTIONS = ";LOCK_MODE=3;MULTI_THREADED=1;DB_CLOSE_ON_EXIT=FALSE;DEFAULT_LOCK_TIMEOUT=10000";
    private static final String OPTIMIZED_DB_OPTIONS = ";OPTIMIZE_REUSE_RESULTS=0;QUERY_CACHE_SIZE=0;RECOMPILE_ALWAYS=1;MAX_OPERATION_MEMORY=0";
    public static final String KEY_FIELD_NAME = "_key";
    public static final String VAL_FIELD_NAME = "_val";
    public static final String VAL_STR_FIELD_NAME = "_gg_val_str__";
    public static final String VER_FIELD_NAME = "_gg_ver__";
    public static final String EXPIRATION_TIME_FIELD_NAME = "_gg_expires__";
    private static final GridIndexingQueryFilter[] EMPTY_FILTER = new GridIndexingQueryFilter[0];
    private static final Object[][] EMPTY_DATA = new Object[0][];
    private static final Field COMMAND_FIELD;
    private static final ThreadLocal<GridH2IndexingSpi> localSpi;
    private Class<?>[] idxCustomFuncClss;
    private String[] searchPath;
    private volatile String cachedSearchPathCmd;
    private String initScriptPath;
    private boolean dfltIdxPrimitiveKey;
    private boolean dfltIdxPrimitiveVal;
    private boolean dfltIdxFixedTyping = true;
    private long maxOffHeapMemory = -1L;
    private long longQryExecTimeout = 3000L;
    private long idxWriteLockWaitTime = 100L;
    private boolean longQryExplain;
    private CacheLongKeyLIRS<GridH2KeyValueRowOffheap> rowCache = new CacheLongKeyLIRS(32768L, 1, 128, 256);
    private Map<String, GridH2IndexingSpaceConfiguration> spaceCfgs = new LinkedHashMap<String, GridH2IndexingSpaceConfiguration>();
    @GridLoggerResource
    private GridLogger log;
    @GridLocalNodeIdResource
    private UUID nodeId;
    @GridMarshallerResource
    private GridMarshaller gridMarshaller;
    private final CountDownLatch ctxInitLatch = new CountDownLatch(1);
    private GridIndexingMarshaller marshaller;
    private GridUnsafeMemory offheap;
    private final Collection<String> schemaNames = new GridConcurrentHashSet();
    private final ConcurrentMap<String, Schema> schemas = new ConcurrentHashMap8();
    private String dbUrl = "jdbc:h2:mem:";
    private final Collection<Connection> conns = Collections.synchronizedCollection(new ArrayList());
    private ThreadLocal<ConnectionWrapper> connCache = new ThreadLocal<ConnectionWrapper>(){

        @Override
        @Nullable
        public ConnectionWrapper get() {
            ConnectionWrapper c = (ConnectionWrapper)super.get();
            boolean reconnect = true;
            try {
                reconnect = c == null || c.connection().isClosed();
            }
            catch (SQLException e) {
                U.warn((GridLogger)GridH2IndexingSpi.this.log, (Object)"Failed to check connection status.", (Object)e);
            }
            if (reconnect) {
                c = this.initialValue();
                this.set(c);
            }
            return c;
        }

        @Override
        @Nullable
        protected ConnectionWrapper initialValue() {
            Connection c = null;
            try {
                c = DriverManager.getConnection(GridH2IndexingSpi.this.dbUrl);
                if (!F.isEmpty((Object[])GridH2IndexingSpi.this.searchPath)) {
                    try (Statement s = c.createStatement();){
                        String cmd = GridH2IndexingSpi.this.cachedSearchPathCmd;
                        if (cmd == null) {
                            SB b = new SB("SET SCHEMA_SEARCH_PATH ");
                            for (int i = 0; i < GridH2IndexingSpi.this.searchPath.length; ++i) {
                                if (i != 0) {
                                    b.a(',');
                                }
                                b.a('\"').a(GridH2IndexingSpi.schema(GridH2IndexingSpi.this.searchPath[i])).a('\"');
                            }
                            cmd = b.toString();
                            GridH2IndexingSpi.this.cachedSearchPathCmd = cmd;
                        }
                        s.executeUpdate(cmd);
                    }
                }
                GridH2IndexingSpi.this.conns.add(c);
                return new ConnectionWrapper(c);
            }
            catch (SQLException e) {
                U.close((Connection)c, (GridLogger)GridH2IndexingSpi.this.log);
                throw new GridRuntimeException("Failed to initialize DB connection: " + GridH2IndexingSpi.this.dbUrl, (Throwable)e);
            }
        }
    };
    private ConcurrentMap<T2<String, Collection<Object>>, GridFutureAdapterEx<QueryResult>> qryResCache = new ConcurrentHashMap8();

    private Connection connectionForThread(@Nullable String schema) throws GridSpiException {
        ConnectionWrapper c = this.connCache.get();
        if (c == null) {
            throw new GridSpiException("Failed to get DB connection for thread (check log for details).");
        }
        if (schema != null && !F.eq((Object)c.schema(), (Object)schema)) {
            Statement stmt = null;
            try {
                stmt = c.connection().createStatement();
                stmt.executeUpdate("SET SCHEMA \"" + schema + '\"');
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Initialized H2 schema for queries on space: " + schema);
                }
                c.schema(schema);
            }
            catch (SQLException e) {
                throw new GridSpiException("Failed to set schema for DB connection for thread [schema=" + schema + "]", (Throwable)e);
            }
            finally {
                U.close((Statement)stmt, (GridLogger)this.log);
            }
        }
        return c.connection();
    }

    private void createSchemaIfAbsent(String schema) throws GridSpiException {
        this.executeStatement("CREATE SCHEMA IF NOT EXISTS \"" + schema + '\"');
        if (this.log.isDebugEnabled()) {
            this.log.debug("Created H2 schema for index database: " + schema);
        }
    }

    private void executeStatement(String sql) throws GridSpiException {
        Statement stmt = null;
        try {
            Connection c = this.connectionForThread(null);
            stmt = c.createStatement();
            stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            try {
                this.onSqlException();
                throw new GridSpiException("Failed to execute statement: " + sql, (Throwable)e);
            }
            catch (Throwable throwable) {
                U.close(stmt, (GridLogger)this.log);
                throw throwable;
            }
        }
        U.close((Statement)stmt, (GridLogger)this.log);
    }

    private <K> void removeKey(@Nullable String spaceName, GridIndexingEntity<K> k, TableDescriptor tblToUpdate) throws GridSpiException {
        Object key = k.value();
        try {
            Collection<TableDescriptor> tbls = this.tables(GridH2IndexingSpi.schema(spaceName));
            if (tbls.size() > 1) {
                boolean fixedTyping = this.isIndexFixedTyping(spaceName);
                for (TableDescriptor tbl : tbls) {
                    if (tbl == tblToUpdate || !tbl.type().keyClass().equals(key.getClass()) && fixedTyping || !tbl.tbl.update(key, null, 0L)) continue;
                    if (tbl.luceneIdx != null) {
                        tbl.luceneIdx.remove(k);
                    }
                    return;
                }
            }
        }
        catch (Exception e) {
            throw new GridSpiException("Failed to remove key: " + key, (Throwable)e);
        }
    }

    private void bindObject(PreparedStatement stmt, int idx, @Nullable Object obj) throws SQLException {
        if (obj == null) {
            stmt.setNull(idx, 12);
        } else {
            stmt.setObject(idx, obj);
        }
    }

    private void onSqlException() {
        Connection conn = this.connCache.get().connection();
        this.connCache.set(null);
        if (conn != null) {
            this.conns.remove(conn);
            U.close((Connection)conn, (GridLogger)this.log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> void store(@Nullable String spaceName, GridIndexingTypeDescriptor type, GridIndexingEntity<K> k, GridIndexingEntity<V> v, byte[] ver, long expirationTime) throws GridSpiException {
        TableDescriptor tbl = this.tableDescriptor(spaceName, type);
        if (tbl == null) {
            return;
        }
        localSpi.set(this);
        try {
            this.removeKey(spaceName, k, tbl);
            if (expirationTime == 0L) {
                expirationTime = Long.MAX_VALUE;
            }
            tbl.tbl.update(k.value(), v.value(), expirationTime);
            if (tbl.luceneIdx != null) {
                tbl.luceneIdx.store(k, v, ver, expirationTime);
            }
        }
        finally {
            localSpi.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K> boolean remove(@Nullable String spaceName, GridIndexingEntity<K> k) throws GridSpiException {
        assert (k != null);
        Object key = k.value();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Removing key from cache query index [locId=" + this.nodeId + ", key=" + key + ']');
        }
        localSpi.set(this);
        try {
            for (TableDescriptor tbl : this.tables(GridH2IndexingSpi.schema(spaceName))) {
                if (!tbl.type().keyClass().equals(key.getClass()) && this.isIndexFixedTyping(spaceName) || !tbl.tbl.update(key, null, 0L)) continue;
                if (tbl.luceneIdx != null) {
                    tbl.luceneIdx.remove(k);
                }
                boolean bl = true;
                return bl;
            }
        }
        finally {
            localSpi.remove();
        }
        return false;
    }

    protected void onContextInitialized0(GridSpiContext spiCtx) throws GridSpiException {
        this.ctxInitLatch.countDown();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Context has been initialized.");
        }
    }

    protected GridSpiContext getSpiContext() {
        if (this.ctxInitLatch.getCount() != 0L) {
            try {
                U.await((CountDownLatch)this.ctxInitLatch);
            }
            catch (GridInterruptedException ignored) {
                U.warn((GridLogger)this.log, (Object)"Thread has been interrupted while waiting for SPI context initialization.");
            }
        }
        return super.getSpiContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <K> void onSwap(@Nullable String spaceName, String swapSpaceName, K key) throws GridSpiException {
        Schema schema = (Schema)((Object)this.schemas.get(GridH2IndexingSpi.schema(spaceName)));
        if (schema == null) {
            return;
        }
        schema.swapSpaceName = swapSpaceName;
        localSpi.set(this);
        try {
            for (TableDescriptor tbl : schema.values()) {
                if (!tbl.type().keyClass().equals(key.getClass()) && this.isIndexFixedTyping(spaceName)) continue;
                try {
                    if (!tbl.tbl.onSwap(key)) continue;
                    return;
                }
                catch (GridException e) {
                    throw new GridSpiException((Throwable)e);
                    return;
                }
            }
        }
        finally {
            localSpi.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <K, V> void onUnswap(@Nullable String spaceName, K key, V val, byte[] valBytes) throws GridSpiException {
        localSpi.set(this);
        try {
            for (TableDescriptor tbl : this.tables(GridH2IndexingSpi.schema(spaceName))) {
                if (!tbl.type().keyClass().equals(key.getClass()) && this.isIndexFixedTyping(spaceName)) continue;
                try {
                    if (!tbl.tbl.onUnswap(key, val)) continue;
                    return;
                }
                catch (GridException e) {
                    throw new GridSpiException((Throwable)e);
                    return;
                }
            }
        }
        finally {
            localSpi.remove();
        }
    }

    private void removeTable(TableDescriptor tbl) throws GridSpiException {
        ConcurrentMap tbls;
        assert (tbl != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Removing query index table: " + tbl.fullTableName());
        }
        Connection c = this.connectionForThread(null);
        Statement stmt = null;
        try {
            stmt = c.createStatement();
            String sql = "DROP TABLE IF EXISTS " + tbl.fullTableName();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Dropping database index table with SQL: " + sql);
            }
            stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            this.onSqlException();
            throw new GridSpiException("Failed to drop database index table [type=" + tbl.type().name() + ", table=" + tbl.fullTableName() + "]", (Throwable)e);
        }
        finally {
            U.close((Statement)stmt, (GridLogger)this.log);
        }
        tbl.tbl.close();
        if (tbl.luceneIdx != null) {
            U.closeQuiet((Closeable)tbl.luceneIdx);
        }
        if (!F.isEmpty((Map)(tbls = (ConcurrentMap)this.schemas.get(tbl.schema())))) {
            tbls.remove(tbl.name());
        }
    }

    public <K, V> GridSpiCloseableIterator<GridIndexingKeyValueRow<K, V>> queryText(@Nullable String spaceName, String qry, GridIndexingTypeDescriptor type, GridIndexingQueryFilter<K, V> ... filters) throws GridSpiException {
        TableDescriptor tbl = this.tableDescriptor(spaceName, type);
        if (tbl != null && tbl.luceneIdx != null) {
            return tbl.luceneIdx.query(qry, filters);
        }
        return new GridEmptyCloseableIterator();
    }

    public void unregisterType(@Nullable String spaceName, GridIndexingTypeDescriptor type) throws GridSpiException {
        TableDescriptor tbl = this.tableDescriptor(spaceName, type);
        if (tbl != null) {
            this.removeTable(tbl);
        }
    }

    /*
     * Exception decompiling
     */
    static Object[][] fetchResult(GridBiTuple<? extends Statement, ResultSet> t) throws GridSpiException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    private Object getCachedResult(T2<String, Collection<Object>> qryParams) throws GridSpiException {
        GridFutureAdapterEx fut = (GridFutureAdapterEx)this.qryResCache.get(qryParams);
        if (fut == null) {
            fut = new GridFutureAdapterEx();
            GridFutureAdapterEx fut0 = this.qryResCache.putIfAbsent(qryParams, (GridFutureAdapterEx<QueryResult>)fut);
            if (fut0 == null) {
                return fut;
            }
            fut = fut0;
        }
        try {
            return fut.get();
        }
        catch (GridException e) {
            throw new GridSpiException((Throwable)e);
        }
    }

    public <K, V> GridIndexingFieldsResult queryFields(@Nullable String spaceName, String qry, @Nullable Collection<Object> params, GridIndexingQueryFilter<K, V> ... filters) throws GridSpiException {
        localSpi.set(this);
        try {
            GridFutureAdapterEx fut;
            Connection conn = this.connectionForThread(GridH2IndexingSpi.schema(spaceName));
            this.setFilters((GridIndexingQueryFilter<?, ?>[])(filters != null ? filters : EMPTY_FILTER));
            T2 qryKey = new T2((Object)qry, params);
            Object x = this.getCachedResult((T2<String, Collection<Object>>)qryKey);
            QueryResult qryRes = x instanceof QueryResult ? (QueryResult)x : null;
            GridFutureAdapterEx gridFutureAdapterEx = fut = qryRes == null ? (GridFutureAdapterEx)x : null;
            if (qryRes == null) {
                assert (fut != null);
                try {
                    T2<PreparedStatement, ResultSet> res = this.executeSqlQueryWithTimer(conn, qry, params);
                    qryRes = new QueryResult();
                    if (res != null) {
                        ArrayList<SqlFieldMetadata> meta;
                        ResultSet rs = (ResultSet)res.get2();
                        try {
                            ResultSetMetaData rsMeta = rs.getMetaData();
                            meta = new ArrayList<SqlFieldMetadata>(rsMeta.getColumnCount());
                            for (int i = 1; i <= rsMeta.getColumnCount(); ++i) {
                                String schemaName = rsMeta.getSchemaName(i);
                                String typeName = rsMeta.getTableName(i);
                                String name = rsMeta.getColumnLabel(i);
                                String type = rsMeta.getColumnClassName(i);
                                meta.add(new SqlFieldMetadata(schemaName, typeName, name, type));
                            }
                        }
                        catch (SQLException e) {
                            throw new GridSpiException("Failed to get meta data.", (Throwable)e);
                        }
                        qryRes.meta = meta;
                        QueryResult.access$1102(qryRes, GridH2IndexingSpi.fetchResult(res));
                    }
                    fut.onDone((Object)qryRes);
                }
                catch (Error | RuntimeException | SQLException | GridSpiException e) {
                    fut.onDone(e);
                    throw e;
                }
                finally {
                    this.qryResCache.remove(qryKey, fut);
                }
            }
            GridIndexingFieldsResultAdapter gridIndexingFieldsResultAdapter = new GridIndexingFieldsResultAdapter(qryRes.meta, (GridSpiCloseableIterator)new FieldsIterator(qryRes.data));
            return gridIndexingFieldsResultAdapter;
        }
        catch (SQLException e) {
            this.onSqlException();
            throw new GridSpiException("Failed to query fields: " + qry, (Throwable)e);
        }
        finally {
            this.setFilters(null);
            localSpi.remove();
        }
    }

    private static int commandType(PreparedStatement stmt) {
        try {
            return ((CommandInterface)COMMAND_FIELD.get(stmt)).getCommandType();
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    @Nullable
    private T2<PreparedStatement, ResultSet> executeSqlQuery(Connection conn, String sql, @Nullable Collection<Object> params) throws SQLException, GridSpiException {
        PreparedStatement stmt;
        try {
            stmt = conn.prepareStatement(sql);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 42102) {
                return null;
            }
            throw new GridSpiException("Failed to parse query: " + sql, (Throwable)e);
        }
        switch (GridH2IndexingSpi.commandType(stmt)) {
            case 21: 
            case 57: 
            case 60: 
            case 66: {
                break;
            }
            default: {
                throw new GridSpiException("Failed to execute non-query SQL statement: " + sql);
            }
        }
        this.bindParameters(stmt, params);
        return new T2((Object)stmt, (Object)stmt.executeQuery());
    }

    private T2<PreparedStatement, ResultSet> executeSqlQueryWithTimer(Connection conn, String sql, @Nullable Collection<Object> params) throws SQLException, GridSpiException {
        long start = U.currentTimeMillis();
        T2<PreparedStatement, ResultSet> res = this.executeSqlQuery(conn, sql, params);
        long time = U.currentTimeMillis() - start;
        if (time > this.longQryExecTimeout) {
            String msg;
            String longMsg = msg = "Query execution is too long (" + time + " ms): " + sql;
            if (this.longQryExplain) {
                T2<PreparedStatement, ResultSet> t2 = this.executeSqlQuery(conn, "EXPLAIN " + sql, params);
                if (t2 == null) {
                    longMsg = "Failed to explain plan because required table does not exist: " + sql;
                } else {
                    ResultSet planRs = (ResultSet)t2.get2();
                    planRs.next();
                    longMsg = "Query execution is too long [time=" + time + " ms, sql='" + sql + '\'' + ", plan=" + U.nl() + planRs.getString(1) + U.nl() + ", parameters=" + params + "]";
                }
            }
            LT.warn((GridLogger)this.log, null, (String)longMsg, (String)msg);
        }
        return res;
    }

    private T2<PreparedStatement, ResultSet> executeQuery(String qry, @Nullable Collection<Object> params, @Nullable TableDescriptor tbl) throws GridSpiException, SQLException {
        Connection conn = this.connectionForThread(tbl != null ? tbl.schema() : "PUBLIC");
        String sql = this.generateQuery(qry, tbl);
        return this.executeSqlQueryWithTimer(conn, sql, params);
    }

    private void bindParameters(PreparedStatement stmt, @Nullable Collection<Object> params) throws SQLException {
        if (!F.isEmpty(params)) {
            int idx = 1;
            for (Object arg : params) {
                this.bindObject(stmt, idx++, arg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> GridSpiCloseableIterator<GridIndexingKeyValueRow<K, V>> query(@Nullable String spaceName, String qry, @Nullable Collection<Object> params, GridIndexingTypeDescriptor type, GridIndexingQueryFilter<K, V> ... filters) throws GridSpiException {
        TableDescriptor tbl = this.tableDescriptor(spaceName, type);
        if (tbl == null) {
            return new GridEmptyCloseableIterator();
        }
        this.setFilters((GridIndexingQueryFilter<?, ?>[])(filters != null ? filters : EMPTY_FILTER));
        localSpi.set(this);
        try {
            GridFutureAdapterEx fut;
            T2 qryKey = new T2((Object)qry, params);
            Object x = this.getCachedResult((T2<String, Collection<Object>>)qryKey);
            QueryResult qryRes = x instanceof QueryResult ? (QueryResult)x : null;
            GridFutureAdapterEx gridFutureAdapterEx = fut = qryRes == null ? (GridFutureAdapterEx)x : null;
            if (qryRes == null) {
                assert (fut != null);
                try {
                    T2<PreparedStatement, ResultSet> t = this.executeQuery(qry, params, tbl);
                    qryRes = new QueryResult();
                    if (t != null) {
                        QueryResult.access$1102(qryRes, GridH2IndexingSpi.fetchResult(t));
                    }
                    fut.onDone((Object)qryRes);
                }
                catch (Error | RuntimeException | SQLException | GridSpiException e) {
                    fut.onDone(e);
                    throw e;
                }
                finally {
                    this.qryResCache.remove(qryKey, fut);
                }
            }
            KeyValIterator keyValIterator = new KeyValIterator(qryRes.data);
            return keyValIterator;
        }
        catch (SQLException e) {
            if (e.getErrorCode() != 42102) {
                this.onSqlException();
                throw new GridSpiException("Failed to query entries: " + qry, (Throwable)e);
            }
            GridEmptyCloseableIterator gridEmptyCloseableIterator = new GridEmptyCloseableIterator();
            return gridEmptyCloseableIterator;
        }
        finally {
            this.setFilters(null);
            localSpi.remove();
        }
    }

    private void setFilters(@Nullable GridIndexingQueryFilter<?, ?>[] filters) {
        GridH2IndexBase.setFiltersForThread(filters);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String generateQuery(String qry, @Nullable TableDescriptor tbl) throws GridSpiException {
        boolean needSelect = tbl != null;
        String str = qry.trim().toUpperCase();
        if (!str.startsWith("FROM")) {
            if (str.startsWith("SELECT")) {
                if (needSelect) {
                    StringTokenizer st = new StringTokenizer(str, " ");
                    String errMsg = "Wrong query format, query must start with 'select * from' or 'from' or without such keywords.";
                    if (st.countTokens() <= 3) throw new GridSpiException(errMsg);
                    st.nextToken();
                    String wildcard = st.nextToken();
                    String from = st.nextToken();
                    if (!"*".equals(wildcard) || !"FROM".equals(from)) {
                        throw new GridSpiException(errMsg);
                    }
                    needSelect = false;
                }
            } else {
                boolean needWhere = !str.startsWith("ORDER") && !str.startsWith("LIMIT");
                qry = needWhere ? "FROM " + tbl.fullTableName() + " WHERE " + qry : "FROM " + tbl.fullTableName() + ' ' + qry;
            }
        }
        GridStringBuilder ptrn = new SB("SELECT {0}.").a(KEY_FIELD_NAME);
        ptrn.a(", {0}.").a(VAL_FIELD_NAME);
        return needSelect ? MessageFormat.format(ptrn.toString(), tbl.fullTableName()) + ' ' + qry : qry;
    }

    public boolean registerType(@Nullable String spaceName, GridIndexingTypeDescriptor type) throws GridSpiException {
        if (!this.validateTypeDescriptor(spaceName, type)) {
            return false;
        }
        for (TableDescriptor table : this.tables(GridH2IndexingSpi.schema(spaceName))) {
            if (!table.type().valueClass().getClass().getName().equals(type.valueClass().getName())) continue;
            throw new GridSpiException("Failed to register type in query index because class is already registered (most likely that class with the same name was not properly undeployed): " + type);
        }
        TableDescriptor tbl = new TableDescriptor(spaceName, type);
        Statement stmt = null;
        try {
            Connection conn = this.connectionForThread(null);
            stmt = conn.createStatement();
            Schema schema = (Schema)((Object)this.schemas.get(tbl.schema()));
            if (schema == null) {
                schema = new Schema(spaceName);
                Schema existing = this.schemas.putIfAbsent(tbl.schema(), schema);
                if (existing != null) {
                    schema = existing;
                }
            }
            this.createTable(schema, tbl, conn);
            schema.put(tbl.name(), tbl);
        }
        catch (SQLException e) {
            try {
                this.onSqlException();
                throw new GridSpiException("Failed to register query type: " + type, (Throwable)e);
            }
            catch (Throwable throwable) {
                U.close(stmt, (GridLogger)this.log);
                throw throwable;
            }
        }
        U.close((Statement)stmt, (GridLogger)this.log);
        return true;
    }

    private boolean isPrimitive(Class<?> cls) {
        DBTypeEnum valType = DBTypeEnum.fromClass(cls);
        return valType != DBTypeEnum.BINARY && valType != DBTypeEnum.OTHER && valType != DBTypeEnum.ARRAY;
    }

    private boolean validateTypeDescriptor(@Nullable String spaceName, GridIndexingTypeDescriptor type) throws GridSpiException {
        assert (type != null);
        boolean keyPrimitive = this.isPrimitive(type.keyClass());
        boolean valPrimitive = this.isPrimitive(type.valueClass());
        if (!type.valueTextIndex() && type.indexes().isEmpty() && type.keyFields().isEmpty() && type.valueFields().isEmpty()) {
            return keyPrimitive && this.isIndexPrimitiveKey(spaceName) || valPrimitive && this.isIndexPrimitiveValue(spaceName);
        }
        HashSet names = new HashSet();
        names.addAll(type.keyFields().keySet());
        names.addAll(type.valueFields().keySet());
        if (names.size() < type.keyFields().size() + type.valueFields().size()) {
            throw new GridSpiException("Found duplicated properties with the same name [keyType=" + type.keyClass().getName() + ", valueType=" + type.valueClass().getName() + "]");
        }
        String ptrn = "Name ''{0}'' is reserved and cannot be used as a field name [class=" + type + "]";
        for (String name : names) {
            if (!name.equals(KEY_FIELD_NAME) && !name.equals(VAL_FIELD_NAME) && !name.equals(VAL_STR_FIELD_NAME) && !name.equals(VER_FIELD_NAME) && !name.equals(EXPIRATION_TIME_FIELD_NAME)) continue;
            throw new GridSpiException(MessageFormat.format(ptrn, name));
        }
        return true;
    }

    private static String escapeName(String name) {
        SB sb = null;
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Character.isLetter(ch) || Character.isDigit(ch) || ch == '_') continue;
            assert (ch == '$' || ch == '.');
            if (sb == null) {
                sb = new SB();
            }
            sb.a(name.substring(sb.length(), i));
            sb.a('_');
        }
        if (sb == null) {
            return name;
        }
        sb.a(name.substring(sb.length(), name.length()));
        return sb.toString();
    }

    private void createTable(Schema schema, TableDescriptor tbl, Connection conn) throws SQLException {
        assert (tbl != null);
        boolean keyAsObj = !this.isIndexFixedTyping(schema.spaceName);
        String keyType = keyAsObj ? "OTHER" : this.dbTypeFromClass(tbl.type().keyClass());
        String valTypeStr = this.dbTypeFromClass(tbl.type().valueClass());
        SB sql = new SB();
        sql.a("CREATE TABLE ").a(tbl.fullTableName()).a(" (").a(KEY_FIELD_NAME).a(' ').a(keyType).a(" NOT NULL");
        sql.a(',').a(VAL_FIELD_NAME).a(' ').a(valTypeStr).a(',').a(VAL_STR_FIELD_NAME).a(' ').a("VARCHAR");
        for (Map.Entry e : tbl.type().keyFields().entrySet()) {
            sql.a(',').a(GridH2IndexingSpi.escapeName((String)e.getKey())).a(' ').a(this.dbTypeFromClass((Class)e.getValue()));
        }
        for (Map.Entry e : tbl.type().valueFields().entrySet()) {
            sql.a(',').a(GridH2IndexingSpi.escapeName((String)e.getKey())).a(' ').a(this.dbTypeFromClass((Class)e.getValue()));
        }
        sql.a(')');
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating DB table with SQL: " + sql);
        }
        RowDescriptor desc = new RowDescriptor(tbl.type(), schema, keyAsObj);
        GridH2Table.Engine.createTable(conn, sql.toString(), desc, tbl, tbl.spaceName);
    }

    private String dbTypeFromClass(Class<?> cls) {
        return DBTypeEnum.fromClass(cls).dBTypeAsString();
    }

    @Nullable
    private TableDescriptor tableDescriptor(@Nullable String spaceName, GridIndexingTypeDescriptor type) {
        return this.tableDescriptor(type.name(), spaceName);
    }

    @Nullable
    private TableDescriptor tableDescriptor(String type, @Nullable String space) {
        ConcurrentMap tbls = (ConcurrentMap)this.schemas.get(GridH2IndexingSpi.schema(space));
        if (tbls == null) {
            return null;
        }
        return (TableDescriptor)tbls.get(type);
    }

    private Collection<TableDescriptor> tables(String schema) {
        ConcurrentMap tbls = (ConcurrentMap)this.schemas.get(schema);
        if (tbls == null) {
            return Collections.emptySet();
        }
        return tbls.values();
    }

    private static String schema(@Nullable String space) {
        if (F.isEmpty((String)space)) {
            return "PUBLIC";
        }
        return space;
    }

    public void rebuildIndexes(@Nullable String spaceName, GridIndexingTypeDescriptor type) {
        if (this.offheap != null) {
            throw new UnsupportedOperationException("Index rebuilding is not supported when off-heap memory is used");
        }
        TableDescriptor tbl = this.tableDescriptor(spaceName, type);
        if (tbl == null) {
            return;
        }
        tbl.tbl.rebuildIndexes();
    }

    public long size(@Nullable String spaceName, GridIndexingTypeDescriptor type) throws GridSpiException {
        Connection conn = this.connectionForThread(null);
        TableDescriptor tbl = this.tableDescriptor(spaceName, type);
        if (tbl == null) {
            return -1L;
        }
        try {
            ResultSet rs = (ResultSet)this.executeSqlQueryWithTimer(conn, "SELECT COUNT(*) FROM " + tbl.fullTableName(), null).get2();
            rs.next();
            return rs.getInt(1);
        }
        catch (SQLException e) {
            U.rollbackConnection((Connection)conn, (GridLogger)this.log);
            this.onSqlException();
            throw new GridSpiException("Failed to get table size: " + tbl.fullTableName(), (Throwable)e);
        }
    }

    public void spiStart(@Nullable String gridName) throws GridSpiException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Starting cache query index...");
        }
        this.assertParameter(this.idxWriteLockWaitTime > 0L, "'idxWriteLockWaitTime' must be positive.");
        this.startStopwatch();
        System.setProperty("h2.serializeJavaObject", "false");
        if (SysProperties.serializeJavaObject) {
            U.warn((GridLogger)this.log, (Object)"Serialization of Java objects in H2 was enabled.");
            SysProperties.serializeJavaObject = false;
        }
        if (this.maxOffHeapMemory != -1L) {
            assert (this.maxOffHeapMemory >= 0L) : this.maxOffHeapMemory;
            this.offheap = new GridUnsafeMemory(this.maxOffHeapMemory);
        }
        SB opt = new SB();
        opt.a(DFLT_DB_OPTIONS).a(OPTIMIZED_DB_OPTIONS);
        String dbName = UUID.randomUUID() + "_" + gridName + "_" + this.getName();
        this.dbUrl = "jdbc:h2:mem:gridgain_indexes_" + dbName + opt;
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new GridSpiException("Failed to find org.h2.Driver class", (Throwable)e);
        }
        this.setH2Serializer();
        for (String schema : this.schemaNames) {
            this.createSchemaIfAbsent(schema);
        }
        try {
            this.createSqlFunctions();
            this.runInitScript();
            if (X.getSystemOrEnv((String)"GRIDGAIN_H2_DEBUG_CONSOLE") != null) {
                Connection c = DriverManager.getConnection(this.dbUrl);
                WebServer webSrv = new WebServer();
                Server web = new Server((Service)webSrv, new String[]{"-webPort", "0"});
                web.start();
                String url = webSrv.addSession(c);
                try {
                    Server.openBrowser((String)url);
                }
                catch (Exception e) {
                    U.warn((GridLogger)this.log, (Object)("Failed to open browser: " + e.getMessage()));
                }
            }
        }
        catch (SQLException e) {
            throw new GridSpiException((Throwable)e);
        }
        this.registerMBean(gridName, this, GridH2IndexingSpiMBean.class);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Cache query index started [grid=" + gridName + ", cache=" + this.getName() + "]");
        }
    }

    private void runInitScript() throws GridSpiException, SQLException {
        if (this.initScriptPath == null) {
            return;
        }
        try (PreparedStatement p = this.connectionForThread(null).prepareStatement("RUNSCRIPT FROM ? CHARSET 'UTF-8'");){
            p.setString(1, this.initScriptPath);
            p.execute();
        }
    }

    private void setH2Serializer() throws GridSpiException {
        this.executeStatement("SET JAVA_OBJECT_SERIALIZER '" + H2Serializer.class.getName() + "'");
    }

    private void createSqlFunctions() throws SQLException, GridSpiException {
        if (F.isEmpty((Object[])this.idxCustomFuncClss)) {
            return;
        }
        for (Class<?> cls : this.idxCustomFuncClss) {
            for (Method m : cls.getDeclaredMethods()) {
                GridCacheQuerySqlFunction ann = m.getAnnotation(GridCacheQuerySqlFunction.class);
                if (ann == null) continue;
                int modifiers = m.getModifiers();
                if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
                    throw new GridSpiException("Method " + m.getName() + " must be public static.");
                }
                String alias = ann.alias().isEmpty() ? m.getName() : ann.alias();
                String clause = "CREATE ALIAS " + alias + (ann.deterministic() ? " DETERMINISTIC FOR \"" : " FOR \"") + cls.getName() + '.' + m.getName() + '\"';
                ArrayList<String> schemas = new ArrayList<String>(this.schemaNames);
                if (!this.schemaNames.contains(GridH2IndexingSpi.schema(null))) {
                    schemas.add(GridH2IndexingSpi.schema(null));
                }
                for (String schema : schemas) {
                    Connection c = this.connectionForThread(schema);
                    Statement s = c.createStatement();
                    s.execute(clause);
                    s.close();
                }
            }
        }
    }

    public void spiStop() throws GridSpiException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopping cache query index...");
        }
        if (this.ctxInitLatch.getCount() != 0L) {
            this.ctxInitLatch.countDown();
        }
        this.unregisterMBean();
        Connection conn = this.connectionForThread(null);
        for (ConcurrentMap m : this.schemas.values()) {
            for (TableDescriptor desc : m.values()) {
                desc.tbl.close();
                if (desc.luceneIdx == null) continue;
                U.closeQuiet((Closeable)desc.luceneIdx);
            }
        }
        if (conn != null) {
            Statement stmt = null;
            try {
                stmt = conn.createStatement();
                stmt.execute("DROP ALL OBJECTS DELETE FILES");
                stmt.execute("SHUTDOWN");
            }
            catch (SQLException e) {
                throw new GridSpiException("Failed to shutdown database.", (Throwable)e);
            }
            finally {
                U.close((Statement)stmt, (GridLogger)this.log);
            }
        }
        for (Connection c : this.conns) {
            U.close((Connection)c, (GridLogger)this.log);
        }
        this.conns.clear();
        this.schemas.clear();
        this.rowCache.clear();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Cache query index stopped [cache=" + this.getName() + "]");
        }
    }

    public void setIndexCustomFunctionClasses(Class<?> ... idxCustomFuncClss) {
        this.idxCustomFuncClss = idxCustomFuncClss;
    }

    @Override
    public String getSpaceNames() {
        return StringUtils.arrayCombine((String[])this.spaceCfgs.keySet().toArray(new String[this.spaceCfgs.size()]), (char)',');
    }

    @Override
    public long getLongQueryExecutionTimeout() {
        return this.longQryExecTimeout;
    }

    @GridSpiConfiguration(optional=true)
    public void setLongQueryExecutionTimeout(long longQryExecTimeout) {
        this.longQryExecTimeout = longQryExecTimeout;
    }

    @Override
    public boolean isLongQueryExplain() {
        return this.longQryExplain;
    }

    @GridSpiConfiguration(optional=true)
    public void setLongQueryExplain(boolean longQryExplain) {
        this.longQryExplain = longQryExplain;
    }

    @Override
    public boolean isIndexPrimitiveKey(@Nullable String spaceName) {
        GridH2IndexingSpaceConfiguration cfg = this.spaceCfgs.get(spaceName);
        if (cfg != null) {
            return cfg.isIndexPrimitiveKey();
        }
        return this.dfltIdxPrimitiveKey;
    }

    @Override
    public boolean isIndexPrimitiveValue(String spaceName) {
        GridH2IndexingSpaceConfiguration cfg = this.spaceCfgs.get(spaceName);
        if (cfg != null) {
            return cfg.isIndexPrimitiveValue();
        }
        return this.dfltIdxPrimitiveVal;
    }

    @Override
    public boolean isIndexFixedTyping(String spaceName) {
        GridH2IndexingSpaceConfiguration cfg = this.spaceCfgs.get(spaceName);
        if (cfg != null) {
            return cfg.isIndexFixedTyping();
        }
        return this.dfltIdxFixedTyping;
    }

    @GridSpiConfiguration(optional=true)
    public void setDefaultIndexPrimitiveValue(boolean dfltIdxPrimitiveVal) {
        this.dfltIdxPrimitiveVal = dfltIdxPrimitiveVal;
    }

    @Override
    public boolean isDefaultIndexPrimitiveValue() {
        return this.dfltIdxPrimitiveVal;
    }

    @GridSpiConfiguration(optional=true)
    public void setDefaultIndexPrimitiveKey(boolean dfltIdxPrimitiveKey) {
        this.dfltIdxPrimitiveKey = dfltIdxPrimitiveKey;
    }

    @Override
    public boolean isDefaultIndexPrimitiveKey() {
        return this.dfltIdxPrimitiveKey;
    }

    @Override
    public boolean isDefaultIndexFixedTyping() {
        return this.dfltIdxFixedTyping;
    }

    @GridSpiConfiguration(optional=true)
    public void setDefaultIndexFixedTyping(boolean dfltIdxFixedTyping) {
        this.dfltIdxFixedTyping = dfltIdxFixedTyping;
    }

    @GridSpiConfiguration(optional=true)
    public void setMaxOffHeapMemory(long maxOffHeapMemory) {
        this.maxOffHeapMemory = maxOffHeapMemory;
    }

    @Override
    public long getMaxOffHeapMemory() {
        return this.maxOffHeapMemory;
    }

    public void setIndexWriteLockWaitTime(long idxWriteLockWaitTime) {
        this.idxWriteLockWaitTime = idxWriteLockWaitTime;
    }

    @Override
    public long getIndexWriteLockWaitTime() {
        return this.idxWriteLockWaitTime;
    }

    @GridSpiConfiguration(optional=true)
    public void setMaxOffheapRowsCacheSize(int size) {
        A.ensure((size >= 128 ? 1 : 0) != 0, (String)"Offheap rows cache size must be not less than 128.");
        this.rowCache = new CacheLongKeyLIRS((long)size, 1, 128, 256);
    }

    @GridSpiConfiguration(optional=true)
    public void setSearchPath(String ... searchPath) {
        this.searchPath = searchPath;
    }

    @Override
    @Nullable
    public String[] getSearchPath() {
        return this.searchPath;
    }

    @Override
    @Nullable
    public String getInitialScriptPath() {
        return this.initScriptPath;
    }

    @GridSpiConfiguration(optional=true)
    public void setInitialScriptPath(String initScriptPath) {
        this.initScriptPath = initScriptPath;
    }

    @Override
    public int getMaxOffheapRowsCacheSize() {
        return (int)this.rowCache.getMaxMemory();
    }

    @Override
    public int getOffheapRowsCacheSize() {
        return (int)this.rowCache.getUsedMemory();
    }

    @Override
    public long getAllocatedOffHeapMemory() {
        return this.offheap == null ? -1L : this.offheap.allocatedSize();
    }

    public void registerMarshaller(GridIndexingMarshaller marshaller) {
        this.marshaller = marshaller;
    }

    public void registerSpace(String spaceName) throws GridSpiException {
        this.schemaNames.add(GridH2IndexingSpi.schema(spaceName));
        if (!this.spaceCfgs.containsKey(spaceName)) {
            this.spaceCfgs.put(spaceName, null);
        }
    }

    @GridSpiConfiguration(optional=true)
    public void setSpaceConfigurations(GridH2IndexingSpaceConfiguration ... spaceCfgs) {
        HashMap<String, GridH2IndexingSpaceConfiguration> map = new HashMap<String, GridH2IndexingSpaceConfiguration>();
        for (GridH2IndexingSpaceConfiguration cfg : spaceCfgs) {
            GridH2IndexingSpaceConfiguration old = map.put(cfg.getName(), cfg);
            assert (old != null) : "Space configured twice: " + cfg.getName();
        }
        this.spaceCfgs = map;
    }

    static /* synthetic */ Object[][] access$2100() {
        return EMPTY_DATA;
    }

    static {
        try {
            COMMAND_FIELD = JdbcPreparedStatement.class.getDeclaredField("command");
            COMMAND_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Check H2 version in classpath.", e);
        }
        localSpi = new ThreadLocal();
    }

    private static class QueryResult {
        private List<GridIndexingFieldMetadata> meta;
        private Object[][] data = GridH2IndexingSpi.access$2100();

        private QueryResult() {
        }

        static /* synthetic */ Object[][] access$1102(QueryResult x0, Object[][] x1) {
            x0.data = x1;
            return x1;
        }
    }

    private static class H2Serializer
    implements JavaObjectSerializer {
        private H2Serializer() {
        }

        public byte[] serialize(Object o) throws Exception {
            return ((GridH2IndexingSpi)localSpi.get()).marshaller.marshal((GridIndexingEntity)new GridIndexingEntityAdapter(o, null));
        }

        public Object deserialize(byte[] bytes) throws Exception {
            return ((GridH2IndexingSpi)localSpi.get()).marshaller.unmarshal(bytes).value();
        }
    }

    private class RowDescriptor
    implements GridH2RowDescriptor {
        private final GridIndexingTypeDescriptor type;
        private final String[] fields;
        private final int[] fieldTypes;
        private final int keyType;
        private final int valType;
        private final Schema schema;
        private final ClassLoader valClsLdr;
        private final int keyCols;

        RowDescriptor(GridIndexingTypeDescriptor type, Schema schema, boolean keyAsObj) {
            assert (type != null);
            assert (schema != null);
            this.type = type;
            this.schema = schema;
            this.keyCols = type.keyFields().size();
            this.valClsLdr = type.valueClass().getClassLoader();
            LinkedHashMap allFields = new LinkedHashMap();
            allFields.putAll(type.keyFields());
            allFields.putAll(type.valueFields());
            this.fields = allFields.keySet().toArray(new String[allFields.size()]);
            this.fieldTypes = new int[this.fields.length];
            Class[] classes = allFields.values().toArray(new Class[this.fields.length]);
            for (int i = 0; i < this.fieldTypes.length; ++i) {
                this.fieldTypes[i] = DataType.getTypeFromClass((Class)classes[i]);
            }
            this.keyType = keyAsObj ? 19 : DataType.getTypeFromClass((Class)type.keyClass());
            this.valType = DataType.getTypeFromClass((Class)type.valueClass());
        }

        @Override
        public void cache(GridH2KeyValueRowOffheap row) {
            long ptr = row.pointer();
            assert (ptr > 0L) : ptr;
            GridH2IndexingSpi.this.rowCache.put(ptr, (Object)row);
        }

        @Override
        public void uncache(long ptr) {
            GridH2IndexingSpi.this.rowCache.remove(ptr);
        }

        @Override
        public GridUnsafeMemory memory() {
            return GridH2IndexingSpi.this.offheap;
        }

        @Override
        public GridH2IndexingSpi spi() {
            return GridH2IndexingSpi.this;
        }

        @Override
        public GridH2AbstractKeyValueRow createRow(Object key, @Nullable Object val, long expirationTime) throws GridSpiException {
            try {
                return GridH2IndexingSpi.this.offheap == null ? new GridH2KeyValueRowOnheap(this, key, this.keyType, val, this.valType, expirationTime) : new GridH2KeyValueRowOffheap(this, key, this.keyType, val, this.valType, expirationTime);
            }
            catch (ClassCastException e) {
                throw new GridSpiException("Failed to convert key to SQL type. Please make sure that you always store each value type with the same key type or disable 'defaultIndexFixedTyping' property on GridH2IndexingSpi.", (Throwable)e);
            }
        }

        @Override
        public Object readFromSwap(Object key) throws GridException {
            GridSpiContext ctx = GridH2IndexingSpi.this.getSpiContext();
            int part = ctx.partition(this.schema.spaceName, key);
            byte[] keyBytes = GridH2IndexingSpi.this.gridMarshaller.marshal(key);
            GridCacheSwapEntry swapEntry = (GridCacheSwapEntry)ctx.readFromOffheap(this.schema.swapSpaceName, part, key, keyBytes, this.valClsLdr);
            if (swapEntry == null && (swapEntry = (GridCacheSwapEntry)ctx.readFromSwap(this.schema.swapSpaceName, new GridSwapKey(key, part, keyBytes), this.valClsLdr)) == null) {
                return null;
            }
            return GridH2IndexingSpi.this.gridMarshaller.unmarshal(swapEntry.valueBytes(), this.valClsLdr);
        }

        @Override
        public int valueType() {
            return this.valType;
        }

        @Override
        public int fieldsCount() {
            return this.fields.length;
        }

        @Override
        public int fieldType(int col) {
            return this.fieldTypes[col];
        }

        @Override
        public Object columnValue(Object obj, int col) {
            try {
                return this.type.value(obj, this.fields[col]);
            }
            catch (GridSpiException e) {
                throw DbException.convert((Throwable)e);
            }
        }

        @Override
        public boolean isKeyColumn(int col) {
            return this.keyCols > col;
        }

        @Override
        public boolean valueToString() {
            return this.type.valueTextIndex();
        }

        public GridH2KeyValueRowOffheap createPointer(long ptr) {
            GridH2KeyValueRowOffheap row = (GridH2KeyValueRowOffheap)GridH2IndexingSpi.this.rowCache.get(ptr);
            if (row != null) {
                assert (row.pointer() == ptr) : ptr + " " + row.pointer();
                return row;
            }
            return new GridH2KeyValueRowOffheap(this, ptr);
        }
    }

    private static class Schema
    extends ConcurrentHashMap8<String, TableDescriptor> {
        private static final long serialVersionUID = 0L;
        private final String spaceName;
        private volatile String swapSpaceName;

        private Schema(@Nullable String spaceName) {
            this.spaceName = spaceName;
        }
    }

    private static class SqlFieldMetadata
    implements GridIndexingFieldMetadata {
        private static final long serialVersionUID = 0L;
        private String schemaName;
        private String typeName;
        private String name;
        private String type;

        public SqlFieldMetadata() {
        }

        SqlFieldMetadata(@Nullable String schemaName, @Nullable String typeName, String name, String type) {
            assert (name != null);
            assert (type != null);
            this.schemaName = schemaName;
            this.typeName = typeName;
            this.name = name;
            this.type = type;
        }

        public String schemaName() {
            return this.schemaName;
        }

        public String typeName() {
            return this.typeName;
        }

        public String fieldName() {
            return this.name;
        }

        public String fieldTypeName() {
            return this.type;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeString((DataOutput)out, (String)this.schemaName);
            U.writeString((DataOutput)out, (String)this.typeName);
            U.writeString((DataOutput)out, (String)this.name);
            U.writeString((DataOutput)out, (String)this.type);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.schemaName = U.readString((DataInput)in);
            this.typeName = U.readString((DataInput)in);
            this.name = U.readString((DataInput)in);
            this.type = U.readString((DataInput)in);
        }

        public String toString() {
            return S.toString(SqlFieldMetadata.class, (Object)this);
        }
    }

    private static class KeyValIterator<K, V>
    extends GridH2ResultSetIterator<GridIndexingKeyValueRow<K, V>> {
        private static final long serialVersionUID = 0L;

        protected KeyValIterator(Object[][] data) {
            super(data);
        }

        @Override
        protected GridIndexingKeyValueRow<K, V> createRow(Object[] row) {
            Object key = row[0];
            Object val = row[1];
            return new GridIndexingKeyValueRowAdapter((GridIndexingEntity)new GridIndexingEntityAdapter(key, null), (GridIndexingEntity)new GridIndexingEntityAdapter(val, null), null);
        }
    }

    private static class FieldsIterator
    extends GridH2ResultSetIterator<List<GridIndexingEntity<?>>> {
        private static final long serialVersionUID = 0L;

        protected FieldsIterator(Object[][] data) {
            super(data);
        }

        @Override
        protected List<GridIndexingEntity<?>> createRow(Object[] arr) {
            ArrayList row = new ArrayList(arr.length);
            for (Object val : arr) {
                row.add((GridIndexingEntity<?>)(val instanceof GridIndexingEntity ? (GridIndexingEntity)val : new GridIndexingEntityAdapter(val, null)));
            }
            return row;
        }
    }

    private class TableDescriptor
    implements GridH2Table.IndexesFactory {
        private final String fullTblName;
        private final GridIndexingTypeDescriptor type;
        private final String spaceName;
        private final String schema;
        private GridH2Table tbl;
        private GridLuceneIndex luceneIdx;

        TableDescriptor(String spaceName, GridIndexingTypeDescriptor type) {
            this.spaceName = spaceName;
            this.type = type;
            this.schema = GridH2IndexingSpi.schema(spaceName);
            this.fullTblName = '\"' + this.schema + "\"." + GridH2IndexingSpi.escapeName(type.name());
        }

        public String schema() {
            return this.schema;
        }

        String fullTableName() {
            return this.fullTblName;
        }

        String name() {
            return this.type.name();
        }

        GridIndexingTypeDescriptor type() {
            return this.type;
        }

        public String toString() {
            return S.toString(TableDescriptor.class, (Object)this);
        }

        @Override
        public ArrayList<Index> createIndexes(GridH2Table tbl) {
            this.tbl = tbl;
            ArrayList<Index> idxs = new ArrayList<Index>();
            idxs.add((Index)new GridH2TreeIndex("_key_PK", tbl, true, 0, 1, GridH2IndexingSpi.this.offheap, tbl.indexColumn(0, 0)));
            if (this.type().valueClass() == String.class) {
                try {
                    this.luceneIdx = new GridLuceneIndex(GridH2IndexingSpi.this.marshaller, GridH2IndexingSpi.this.offheap, this.spaceName, this.type, true);
                }
                catch (GridSpiException e1) {
                    throw new GridRuntimeException((Throwable)e1);
                }
            }
            for (Map.Entry e : this.type.indexes().entrySet()) {
                String name = (String)e.getKey();
                GridIndexDescriptor idx = (GridIndexDescriptor)e.getValue();
                if (idx.type() == GridIndexType.FULLTEXT) {
                    try {
                        this.luceneIdx = new GridLuceneIndex(GridH2IndexingSpi.this.marshaller, GridH2IndexingSpi.this.offheap, this.spaceName, this.type, true);
                        continue;
                    }
                    catch (GridSpiException e1) {
                        throw new GridRuntimeException((Throwable)e1);
                    }
                }
                IndexColumn[] cols = new IndexColumn[idx.fields().size()];
                int i = 0;
                for (String field : idx.fields()) {
                    Column col = tbl.getColumn(field.toUpperCase());
                    cols[i++] = tbl.indexColumn(col.getColumnId(), idx.descending(field) ? 1 : 0);
                }
                if (idx.type() == GridIndexType.SORTED) {
                    idxs.add((Index)new GridH2TreeIndex(name, tbl, false, 0, 1, GridH2IndexingSpi.this.offheap, cols));
                    continue;
                }
                if (idx.type() == GridIndexType.GEO_SPATIAL) {
                    idxs.add((Index)new GridH2SpatialIndex((Table)tbl, name, cols, 0, 1));
                    continue;
                }
                throw new IllegalStateException();
            }
            return idxs;
        }
    }

    private static enum DBTypeEnum {
        INT("INT"),
        BOOL("BOOL"),
        TINYINT("TINYINT"),
        SMALLINT("SMALLINT"),
        BIGINT("BIGINT"),
        DECIMAL("DECIMAL"),
        DOUBLE("DOUBLE"),
        REAL("REAL"),
        TIME("TIME"),
        TIMESTAMP("TIMESTAMP"),
        DATE("DATE"),
        VARCHAR("VARCHAR"),
        CHAR("CHAR"),
        BINARY("BINARY"),
        UUID("UUID"),
        ARRAY("ARRAY"),
        GEOMETRY("GEOMETRY"),
        OTHER("OTHER");

        private static final Map<Class<?>, DBTypeEnum> map;
        private final String dbType;

        private DBTypeEnum(String dbType) {
            this.dbType = dbType;
        }

        public static DBTypeEnum fromClass(Class<?> cls) {
            DBTypeEnum res = map.get(cls);
            if (res != null) {
                return res;
            }
            if (DataType.isGeometryClass(cls)) {
                return GEOMETRY;
            }
            return cls.isArray() && !cls.getComponentType().isPrimitive() ? ARRAY : OTHER;
        }

        public String dBTypeAsString() {
            return this.dbType;
        }

        public String toString() {
            return S.toString(DBTypeEnum.class, (Object)((Object)this));
        }

        static {
            map = new HashMap();
            map.put(Integer.TYPE, INT);
            map.put(Integer.class, INT);
            map.put(Boolean.TYPE, BOOL);
            map.put(Boolean.class, BOOL);
            map.put(Byte.TYPE, TINYINT);
            map.put(Byte.class, TINYINT);
            map.put(Short.TYPE, SMALLINT);
            map.put(Short.class, SMALLINT);
            map.put(Long.TYPE, BIGINT);
            map.put(Long.class, BIGINT);
            map.put(BigDecimal.class, DECIMAL);
            map.put(Double.TYPE, DOUBLE);
            map.put(Double.class, DOUBLE);
            map.put(Float.TYPE, REAL);
            map.put(Float.class, REAL);
            map.put(Time.class, TIME);
            map.put(Timestamp.class, TIMESTAMP);
            map.put(Date.class, TIMESTAMP);
            map.put(java.sql.Date.class, DATE);
            map.put(Character.TYPE, CHAR);
            map.put(Character.class, CHAR);
            map.put(String.class, VARCHAR);
            map.put(UUID.class, UUID);
            map.put(byte[].class, BINARY);
        }
    }

    private static class ConnectionWrapper {
        private Connection conn;
        private volatile String schema;

        ConnectionWrapper(Connection conn) {
            this.conn = conn;
        }

        public String schema() {
            return this.schema;
        }

        public void schema(@Nullable String schema) {
            this.schema = schema;
        }

        public Connection connection() {
            return this.conn;
        }

        public String toString() {
            return S.toString(ConnectionWrapper.class, (Object)this);
        }
    }
}

