/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.greendao.generator;

import org.greenrobot.greendao.generator.DaoUtil;
import org.greenrobot.greendao.generator.Entity;
import org.greenrobot.greendao.generator.Index;
import org.greenrobot.greendao.generator.PropertyType;
import org.greenrobot.greendao.generator.Schema;

public class Property {
    private final Schema schema;
    private final Entity entity;
    private PropertyType propertyType;
    private final String propertyName;
    private String columnName;
    private String columnType;
    private String customType;
    private String customTypeClassName;
    private String converter;
    private String converterClassName;
    private String codeBeforeField;
    private String codeBeforeGetter;
    private String codeBeforeSetter;
    private String javaDocField;
    private String javaDocGetter;
    private String javaDocSetter;
    private boolean primaryKey;
    private boolean pkAsc;
    private boolean pkDesc;
    private boolean pkAutoincrement;
    private boolean unique;
    private boolean notNull;
    private String constraints;
    private int ordinal;
    private String javaType;
    private boolean nonDefaultColumnName;
    private Index index;

    public Property(Schema schema, Entity entity, PropertyType propertyType, String propertyName) {
        this.schema = schema;
        this.entity = entity;
        this.propertyName = propertyName;
        this.propertyType = propertyType;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public PropertyType getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(PropertyType propertyType) {
        this.propertyType = propertyType;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public boolean isNonDefaultColumnName() {
        return this.nonDefaultColumnName;
    }

    public String getColumnType() {
        return this.columnType;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public boolean isPkAsc() {
        return this.pkAsc;
    }

    public boolean isPkDesc() {
        return this.pkDesc;
    }

    public boolean isAutoincrement() {
        return this.pkAutoincrement;
    }

    public String getConstraints() {
        return this.constraints;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public String getJavaTypeInEntity() {
        if (this.customTypeClassName != null) {
            return this.customTypeClassName;
        }
        return this.javaType;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    public String getCustomType() {
        return this.customType;
    }

    public String getCustomTypeClassName() {
        return this.customTypeClassName;
    }

    public String getConverter() {
        return this.converter;
    }

    public String getConverterClassName() {
        return this.converterClassName;
    }

    public String getCodeBeforeField() {
        return this.codeBeforeField;
    }

    public String getCodeBeforeGetter() {
        return this.codeBeforeGetter;
    }

    public String getCodeBeforeSetter() {
        return this.codeBeforeSetter;
    }

    public String getJavaDocField() {
        return this.javaDocField;
    }

    public String getJavaDocGetter() {
        return this.javaDocGetter;
    }

    public String getJavaDocSetter() {
        return this.javaDocSetter;
    }

    public String getDatabaseValueExpression() {
        return this.getDatabaseValueExpression(this.propertyName);
    }

    public String getDatabaseValueExpressionNotNull() {
        return this.getDatabaseValueExpression("entity.get" + DaoUtil.capFirst(this.propertyName) + "()");
    }

    public String getDatabaseValueExpression(String entityValue) {
        StringBuilder builder = new StringBuilder();
        if (this.customType != null) {
            builder.append(this.propertyName).append("Converter.convertToDatabaseValue(");
        }
        builder.append(entityValue);
        if (this.customType != null) {
            builder.append(')');
        }
        if (this.propertyType == PropertyType.Boolean) {
            builder.append(" ? 1L: 0L");
        } else if (this.propertyType == PropertyType.Date) {
            builder.append(".getTime()");
        }
        return builder.toString();
    }

    public String getEntityValueExpression(String databaseValue) {
        StringBuilder builder = new StringBuilder();
        if (this.customType != null) {
            builder.append(this.propertyName).append("Converter.convertToEntityProperty(");
        }
        if (this.propertyType == PropertyType.Byte) {
            builder.append("(byte) ");
        } else if (this.propertyType == PropertyType.Date) {
            builder.append("new java.util.Date(");
        }
        builder.append(databaseValue);
        if (this.propertyType == PropertyType.Boolean) {
            builder.append(" != 0");
        } else if (this.propertyType == PropertyType.Date) {
            builder.append(")");
        }
        if (this.customType != null) {
            builder.append(')');
        }
        return builder.toString();
    }

    public Entity getEntity() {
        return this.entity;
    }

    public Index getIndex() {
        return this.index;
    }

    public void setIndex(Index index) {
        this.index = index;
    }

    void init2ndPass() {
        this.initConstraint();
        if (this.columnType == null) {
            this.columnType = this.schema.mapToDbType(this.propertyType);
        }
        if (this.columnName == null) {
            this.columnName = DaoUtil.dbName(this.propertyName);
            this.nonDefaultColumnName = false;
        } else if (this.primaryKey && this.propertyType == PropertyType.Long && this.columnName.equals("_id")) {
            this.nonDefaultColumnName = false;
        }
        this.javaType = this.notNull ? this.schema.mapToJavaTypeNotNull(this.propertyType) : this.schema.mapToJavaTypeNullable(this.propertyType);
    }

    private void initConstraint() {
        StringBuilder constraintBuilder = new StringBuilder();
        if (this.primaryKey) {
            constraintBuilder.append("PRIMARY KEY");
            if (this.pkAsc) {
                constraintBuilder.append(" ASC");
            }
            if (this.pkDesc) {
                constraintBuilder.append(" DESC");
            }
            if (this.pkAutoincrement) {
                constraintBuilder.append(" AUTOINCREMENT");
            }
        }
        if (this.notNull || this.primaryKey && this.propertyType == PropertyType.String) {
            constraintBuilder.append(" NOT NULL");
        }
        if (this.unique) {
            constraintBuilder.append(" UNIQUE");
        }
        String newContraints = constraintBuilder.toString().trim();
        if (constraintBuilder.length() > 0) {
            this.constraints = newContraints;
        }
    }

    void init3ndPass() {
    }

    public String toString() {
        return "Property " + this.propertyName + " of " + this.entity.getClassName();
    }

    public static class PropertyBuilder {
        private final Property property;

        public PropertyBuilder(Schema schema, Entity entity, PropertyType propertyType, String propertyName) {
            this.property = new Property(schema, entity, propertyType, propertyName);
        }

        public PropertyBuilder columnName(String columnName) {
            this.property.columnName = columnName;
            this.property.nonDefaultColumnName = columnName != null;
            return this;
        }

        public PropertyBuilder columnType(String columnType) {
            this.property.columnType = columnType;
            return this;
        }

        public PropertyBuilder primaryKey() {
            this.property.primaryKey = true;
            return this;
        }

        public PropertyBuilder primaryKeyAsc() {
            this.property.primaryKey = true;
            this.property.pkAsc = true;
            return this;
        }

        public PropertyBuilder primaryKeyDesc() {
            this.property.primaryKey = true;
            this.property.pkDesc = true;
            return this;
        }

        public PropertyBuilder autoincrement() {
            if (!this.property.primaryKey || this.property.propertyType != PropertyType.Long) {
                throw new RuntimeException("AUTOINCREMENT is only available to primary key properties of type long/Long");
            }
            this.property.pkAutoincrement = true;
            return this;
        }

        public PropertyBuilder unique() {
            this.property.unique = true;
            return this;
        }

        public PropertyBuilder notNull() {
            this.property.notNull = true;
            return this;
        }

        public PropertyBuilder index() {
            Index index = new Index();
            index.addProperty(this.property);
            this.property.entity.addIndex(index);
            return this;
        }

        public PropertyBuilder indexAsc(String indexNameOrNull, boolean isUnique) {
            Index index = new Index();
            index.addPropertyAsc(this.property);
            if (isUnique) {
                index.makeUnique();
            }
            index.setName(indexNameOrNull);
            this.property.entity.addIndex(index);
            return this;
        }

        public PropertyBuilder indexDesc(String indexNameOrNull, boolean isUnique) {
            Index index = new Index();
            index.addPropertyDesc(this.property);
            if (isUnique) {
                index.makeUnique();
            }
            index.setName(indexNameOrNull);
            this.property.entity.addIndex(index);
            return this;
        }

        public PropertyBuilder customType(String customType, String converter) {
            this.property.customType = customType;
            this.property.customTypeClassName = DaoUtil.getClassnameFromFullyQualified(customType);
            this.property.converter = converter;
            this.property.converterClassName = DaoUtil.getClassnameFromFullyQualified(converter);
            return this;
        }

        public PropertyBuilder codeBeforeField(String code) {
            this.property.codeBeforeField = code;
            return this;
        }

        public PropertyBuilder codeBeforeGetter(String code) {
            this.property.codeBeforeGetter = code;
            return this;
        }

        public PropertyBuilder codeBeforeSetter(String code) {
            this.property.codeBeforeSetter = code;
            return this;
        }

        public PropertyBuilder codeBeforeGetterAndSetter(String code) {
            this.property.codeBeforeGetter = code;
            this.property.codeBeforeSetter = code;
            return this;
        }

        public PropertyBuilder javaDocField(String javaDoc) {
            this.property.javaDocField = this.checkConvertToJavaDoc(javaDoc);
            return this;
        }

        private String checkConvertToJavaDoc(String javaDoc) {
            return DaoUtil.checkConvertToJavaDoc(javaDoc, "    ");
        }

        public PropertyBuilder javaDocGetter(String javaDoc) {
            this.property.javaDocGetter = this.checkConvertToJavaDoc(javaDoc);
            return this;
        }

        public PropertyBuilder javaDocSetter(String javaDoc) {
            this.property.javaDocSetter = this.checkConvertToJavaDoc(javaDoc);
            return this;
        }

        public PropertyBuilder javaDocGetterAndSetter(String javaDoc) {
            javaDoc = this.checkConvertToJavaDoc(javaDoc);
            this.property.javaDocGetter = javaDoc;
            this.property.javaDocSetter = javaDoc;
            return this;
        }

        public Property getProperty() {
            return this.property;
        }
    }
}

