/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.greendao.generator;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DaoUtil {
    public static String dbName(String javaName) {
        StringBuilder builder = new StringBuilder(javaName);
        for (int i = 1; i < builder.length(); ++i) {
            boolean lastWasUpper = Character.isUpperCase(builder.charAt(i - 1));
            boolean isUpper = Character.isUpperCase(builder.charAt(i));
            if (!isUpper || lastWasUpper) continue;
            builder.insert(i, '_');
            ++i;
        }
        return builder.toString().toUpperCase();
    }

    public static String getClassnameFromFullyQualified(String clazz) {
        int index = clazz.lastIndexOf(46);
        if (index != -1) {
            return clazz.substring(index + 1);
        }
        return clazz;
    }

    public static String capFirst(String string) {
        return Character.toUpperCase(string.charAt(0)) + (string.length() > 1 ? string.substring(1) : "");
    }

    public static String getPackageFromFullyQualified(String clazz) {
        int index = clazz.lastIndexOf(46);
        if (index != -1) {
            return clazz.substring(0, index);
        }
        return null;
    }

    public static byte[] readAllBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DaoUtil.copyAllBytes(in, out);
        return out.toByteArray();
    }

    public static byte[] readAllBytes(File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            byte[] byArray = DaoUtil.readAllBytes(is);
            return byArray;
        }
    }

    public static byte[] readAllBytes(String filename) throws IOException {
        try (FileInputStream is = new FileInputStream(filename);){
            byte[] byArray = DaoUtil.readAllBytes(is);
            return byArray;
        }
    }

    public static int copyAllBytes(InputStream in, OutputStream out) throws IOException {
        int read;
        int byteCount = 0;
        byte[] buffer = new byte[4096];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
            byteCount += read;
        }
        return byteCount;
    }

    public static String checkConvertToJavaDoc(String javaDoc, String indent) {
        if (javaDoc != null && !javaDoc.trim().startsWith("/**")) {
            javaDoc = javaDoc.replace("\n", "\n" + indent + " * ");
            javaDoc = indent + "/**\n" + indent + " * " + javaDoc + "\n" + indent + " */";
        }
        return javaDoc;
    }
}

