/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.greendao.generator;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.greenrobot.greendao.generator.ContentProvider;
import org.greenrobot.greendao.generator.DaoUtil;
import org.greenrobot.greendao.generator.Entity;
import org.greenrobot.greendao.generator.Schema;

public class DaoGenerator {
    private Pattern patternKeepIncludes;
    private Pattern patternKeepFields;
    private Pattern patternKeepMethods;
    private Template templateDao;
    private Template templateDaoMaster;
    private Template templateDaoSession;
    private Template templateEntity;
    private Template templateDaoUnitTest;
    private Template templateContentProvider;

    public DaoGenerator() throws IOException {
        this(false);
    }

    public DaoGenerator(boolean encryption) throws IOException {
        System.out.println("greenDAO Generator" + (encryption ? " (enryption mode)" : ""));
        System.out.println("Copyright 2011-2016 Markus Junginger, greenrobot.de. Licensed under GPL V3.");
        System.out.println("This program comes with ABSOLUTELY NO WARRANTY");
        this.patternKeepIncludes = this.compilePattern("INCLUDES");
        this.patternKeepFields = this.compilePattern("FIELDS");
        this.patternKeepMethods = this.compilePattern("METHODS");
        Configuration config = new Configuration(Configuration.VERSION_2_3_23);
        String basePackagePath = encryption ? "/encryption/" : "/standard/";
        config.setClassForTemplateLoading(this.getClass(), basePackagePath);
        this.templateDao = config.getTemplate("dao.ftl");
        this.templateDaoMaster = config.getTemplate("dao-master.ftl");
        this.templateDaoSession = config.getTemplate("dao-session.ftl");
        this.templateEntity = config.getTemplate("entity.ftl");
        this.templateDaoUnitTest = config.getTemplate("dao-unit-test.ftl");
        this.templateContentProvider = config.getTemplate("content-provider.ftl");
    }

    private Pattern compilePattern(String sectionName) {
        int flags = 40;
        return Pattern.compile(".*^\\s*?//\\s*?KEEP " + sectionName + ".*?\n(.*?)^\\s*// KEEP " + sectionName + " END.*?\n", flags);
    }

    public void generateAll(Schema schema, String outDir) throws Exception {
        this.generateAll(schema, outDir, null, null);
    }

    public void generateAll(Schema schema, String outDir, String outDirEntity, String outDirTest) throws Exception {
        long start = System.currentTimeMillis();
        File outDirFile = this.toFileForceExists(outDir);
        File outDirEntityFile = outDirEntity != null ? this.toFileForceExists(outDirEntity) : outDirFile;
        File outDirTestFile = outDirTest != null ? this.toFileForceExists(outDirTest) : null;
        schema.init2ndPass();
        schema.init3rdPass();
        System.out.println("Processing schema version " + schema.getVersion() + "...");
        List<Entity> entities = schema.getEntities();
        for (Entity entity : entities) {
            this.generate(this.templateDao, outDirFile, entity.getJavaPackageDao(), entity.getClassNameDao(), schema, entity);
            if (!entity.isProtobuf() && !entity.isSkipGeneration()) {
                this.generate(this.templateEntity, outDirEntityFile, entity.getJavaPackage(), entity.getClassName(), schema, entity);
            }
            if (outDirTestFile != null && !entity.isSkipGenerationTest()) {
                String classNameTest;
                String javaPackageTest = entity.getJavaPackageTest();
                File javaFilename = this.toJavaFilename(outDirTestFile, javaPackageTest, classNameTest = entity.getClassNameTest());
                if (!javaFilename.exists()) {
                    this.generate(this.templateDaoUnitTest, outDirTestFile, javaPackageTest, classNameTest, schema, entity);
                } else {
                    System.out.println("Skipped " + javaFilename.getCanonicalPath());
                }
            }
            for (ContentProvider contentProvider : entity.getContentProviders()) {
                HashMap<String, Object> additionalObjectsForTemplate = new HashMap<String, Object>();
                additionalObjectsForTemplate.put("contentProvider", contentProvider);
                this.generate(this.templateContentProvider, outDirFile, entity.getJavaPackage(), entity.getClassName() + "ContentProvider", schema, entity, additionalObjectsForTemplate);
            }
        }
        this.generate(this.templateDaoMaster, outDirFile, schema.getDefaultJavaPackageDao(), schema.getPrefix() + "DaoMaster", schema, null);
        this.generate(this.templateDaoSession, outDirFile, schema.getDefaultJavaPackageDao(), schema.getPrefix() + "DaoSession", schema, null);
        long time = System.currentTimeMillis() - start;
        System.out.println("Processed " + entities.size() + " entities in " + time + "ms");
    }

    protected File toFileForceExists(String filename) throws IOException {
        File file = new File(filename);
        if (!file.exists()) {
            throw new IOException(filename + " does not exist. This check is to prevent accidental file generation into a wrong path.");
        }
        return file;
    }

    private void generate(Template template, File outDirFile, String javaPackage, String javaClassName, Schema schema, Entity entity) throws Exception {
        this.generate(template, outDirFile, javaPackage, javaClassName, schema, entity, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generate(Template template, File outDirFile, String javaPackage, String javaClassName, Schema schema, Entity entity, Map<String, Object> additionalObjectsForTemplate) throws Exception {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("schema", schema);
        root.put("entity", entity);
        if (additionalObjectsForTemplate != null) {
            root.putAll(additionalObjectsForTemplate);
        }
        try {
            File file = this.toJavaFilename(outDirFile, javaPackage, javaClassName);
            file.getParentFile().mkdirs();
            if (entity != null && entity.getHasKeepSections().booleanValue()) {
                this.checkKeepSections(file, root);
            }
            try (FileWriter writer = new FileWriter(file);){
                template.process(root, (Writer)writer);
                ((Writer)writer).flush();
                System.out.println("Written " + file.getCanonicalPath());
            }
        }
        catch (Exception ex) {
            System.err.println("Data map for template: " + root);
            System.err.println("Error while generating " + javaPackage + "." + javaClassName + " (" + outDirFile.getCanonicalPath() + ")");
            throw ex;
        }
    }

    private void checkKeepSections(File file, Map<String, Object> root) {
        if (file.exists()) {
            try {
                String contents = new String(DaoUtil.readAllBytes(file));
                Matcher matcher = this.patternKeepIncludes.matcher(contents);
                if (matcher.matches()) {
                    root.put("keepIncludes", matcher.group(1));
                }
                if ((matcher = this.patternKeepFields.matcher(contents)).matches()) {
                    root.put("keepFields", matcher.group(1));
                }
                if ((matcher = this.patternKeepMethods.matcher(contents)).matches()) {
                    root.put("keepMethods", matcher.group(1));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected File toJavaFilename(File outDirFile, String javaPackage, String javaClassName) {
        String packageSubPath = javaPackage.replace('.', '/');
        File packagePath = new File(outDirFile, packageSubPath);
        return new File(packagePath, javaClassName + ".java");
    }
}

