/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.greendao.generator;

import org.greenrobot.greendao.generator.Entity;
import org.greenrobot.greendao.generator.Property;
import org.greenrobot.greendao.generator.PropertyType;
import org.greenrobot.greendao.generator.Schema;

public class ToOne {
    private final Schema schema;
    private final Entity sourceEntity;
    private final Entity targetEntity;
    private final Property[] fkProperties;
    private final String[] resolvedKeyJavaType;
    private final boolean[] resolvedKeyUseEquals;
    private String name;
    private final boolean useFkProperty;

    public ToOne(Schema schema, Entity sourceEntity, Entity targetEntity, Property[] fkProperties, boolean useFkProperty) {
        this.schema = schema;
        this.sourceEntity = sourceEntity;
        this.targetEntity = targetEntity;
        this.fkProperties = fkProperties;
        this.useFkProperty = useFkProperty;
        this.resolvedKeyJavaType = new String[fkProperties.length];
        this.resolvedKeyUseEquals = new boolean[fkProperties.length];
    }

    public Entity getSourceEntity() {
        return this.sourceEntity;
    }

    public Entity getTargetEntity() {
        return this.targetEntity;
    }

    public Property[] getFkProperties() {
        return this.fkProperties;
    }

    public String[] getResolvedKeyJavaType() {
        return this.resolvedKeyJavaType;
    }

    public boolean[] getResolvedKeyUseEquals() {
        return this.resolvedKeyUseEquals;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isUseFkProperty() {
        return this.useFkProperty;
    }

    void init2ndPass() {
        if (this.name == null) {
            char[] nameCharArray = this.targetEntity.getClassName().toCharArray();
            nameCharArray[0] = Character.toLowerCase(nameCharArray[0]);
            this.name = new String(nameCharArray);
        }
    }

    void init3ndPass() {
        Property targetPkProperty = this.targetEntity.getPkProperty();
        if (this.fkProperties.length != 1 || targetPkProperty == null) {
            throw new RuntimeException("Currently only single FK columns are supported: " + this);
        }
        Property property = this.fkProperties[0];
        PropertyType propertyType = property.getPropertyType();
        if (propertyType == null) {
            propertyType = targetPkProperty.getPropertyType();
            property.setPropertyType(propertyType);
            property.init2ndPass();
            property.init3ndPass();
        } else if (propertyType != targetPkProperty.getPropertyType()) {
            System.err.println("Warning to-one property type does not match target key type: " + this);
        }
        this.resolvedKeyJavaType[0] = this.schema.mapToJavaTypeNullable(propertyType);
        this.resolvedKeyUseEquals[0] = this.checkUseEquals(propertyType);
    }

    protected boolean checkUseEquals(PropertyType propertyType) {
        boolean useEquals;
        switch (propertyType) {
            case Byte: 
            case Short: 
            case Int: 
            case Long: 
            case Boolean: 
            case Float: {
                useEquals = true;
                break;
            }
            default: {
                useEquals = false;
            }
        }
        return useEquals;
    }

    public String toString() {
        String sourceName = this.sourceEntity != null ? this.sourceEntity.getClassName() : null;
        String targetName = this.targetEntity != null ? this.targetEntity.getClassName() : null;
        return "ToOne '" + this.name + "' from " + sourceName + " to " + targetName;
    }
}

