/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest;

import com.google.common.base.Joiner;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceModel;
import org.glassfish.jersey.uri.PathPattern;

public class PrintModelProcessor
implements ModelProcessor {
    public ResourceModel processResourceModel(ResourceModel resourceModel, Configuration configuration) {
        System.out.println("Map for resource model <" + resourceModel + ">:");
        for (Resource resource : resourceModel.getResources()) {
            for (ResourceMethod resourceMethod : resource.getAllMethods()) {
                System.out.println(this.formatEndpoint(resourceMethod.getHttpMethod(), resource.getPathPattern(), resource.getHandlerClasses()));
            }
        }
        return resourceModel;
    }

    public ResourceModel processSubResource(ResourceModel subResourceModel, Configuration configuration) {
        System.out.println("Map for sub-resource model <" + subResourceModel + ">:");
        for (Resource resource : subResourceModel.getResources()) {
            for (ResourceMethod resourceMethod : resource.getAllMethods()) {
                System.out.println(this.formatEndpoint(resourceMethod.getHttpMethod(), resource.getPathPattern(), resource.getHandlerClasses()));
            }
        }
        return subResourceModel;
    }

    private String formatEndpoint(String method, PathPattern pathPattern, Iterable<Class<?>> handlerClasses) {
        return String.format("    %-7s %s (%s)", method, pathPattern, Joiner.on((String)", ").join(handlerClasses));
    }
}

