/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.graylog2.shared.rest.RangeJsonSerializer;

@Provider
public class ObjectMapperProvider
implements ContextResolver<ObjectMapper> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public ObjectMapperProvider() {
        this.objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.objectMapper.setPropertyNamingStrategy((PropertyNamingStrategy)new PreserveLeadingUnderscoreStrategy());
        this.objectMapper.registerModule((Module)new JodaModule());
        this.objectMapper.registerModule((Module)new GuavaModule());
        SimpleModule module = new SimpleModule(){
            {
                this.addSerializer(new RangeJsonSerializer());
            }
        };
        this.objectMapper.registerModule((Module)module);
    }

    public ObjectMapper getContext(Class<?> type) {
        return this.objectMapper;
    }

    public class PreserveLeadingUnderscoreStrategy
    extends PropertyNamingStrategy.LowerCaseWithUnderscoresStrategy {
        public String translate(String input) {
            String translated = super.translate(input);
            if (input.startsWith("_") && !translated.startsWith("_")) {
                translated = "_" + translated;
            }
            return translated;
        }
    }
}

