/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.inputs;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.shared.bindings.InstantiationService;
import org.graylog2.shared.inputs.NoSuchInputTypeException;

public class MessageInputFactory {
    private final InstantiationService instantiationService;
    private final Set<Class<? extends MessageInput>> implClasses;

    @Inject
    public MessageInputFactory(InstantiationService instantiationService, Set<Class<? extends MessageInput>> implClasses) {
        this.instantiationService = instantiationService;
        this.implClasses = implClasses;
    }

    public MessageInput create(String type) throws NoSuchInputTypeException {
        try {
            for (Class<? extends MessageInput> implClass : this.implClasses) {
                if (!implClass.getCanonicalName().equals(type)) continue;
                return this.instantiationService.getInstance(implClass);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create input of type <" + type + ">", e);
        }
        throw new NoSuchInputTypeException("There is no input of type <" + type + "> registered.");
    }

    public Map<String, String> getAvailableInputs() {
        HashMap result = Maps.newHashMap();
        for (Class<? extends MessageInput> implClass : this.implClasses) {
            MessageInput instance = this.instantiationService.getInstance(implClass);
            result.put(implClass.getCanonicalName(), instance.getName());
        }
        return result;
    }
}

