/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.initializers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.internal.util.;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Path;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.ExceptionMapper;
import org.glassfish.jersey.message.GZipEncoder;
import org.glassfish.jersey.server.ContainerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.ResourceFinder;
import org.glassfish.jersey.server.filter.EncodingFilter;
import org.glassfish.jersey.server.internal.scanning.PackageNamesScanner;
import org.glassfish.jersey.server.model.Resource;
import org.graylog2.jersey.container.netty.NettyContainer;
import org.graylog2.jersey.container.netty.SecurityContextFactory;
import org.graylog2.plugin.BaseConfiguration;
import org.graylog2.plugin.rest.AnyExceptionClassMapper;
import org.graylog2.plugin.rest.JacksonPropertyExceptionMapper;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.plugin.rest.WebApplicationExceptionMapper;
import org.graylog2.shared.rest.CORSFilter;
import org.graylog2.shared.rest.PrintModelProcessor;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RestApiService
extends AbstractIdleService {
    private static final Logger LOG = LoggerFactory.getLogger(RestApiService.class);
    private final BaseConfiguration configuration;
    private final SecurityContextFactory securityContextFactory;
    private final Set<Class<? extends DynamicFeature>> dynamicFeatures;
    private final Set<Class<? extends ContainerResponseFilter>> containerResponseFilters;
    private final Set<Class<? extends ExceptionMapper>> exceptionMappers;
    private final Map<String, Set<PluginRestResource>> pluginRestResources;
    private final ObjectMapper objectMapper;
    private ServerBootstrap bootstrap;

    @Inject
    public RestApiService(BaseConfiguration configuration, @.Nullable SecurityContextFactory securityContextFactory, Set<Class<? extends DynamicFeature>> dynamicFeatures, Set<Class<? extends ContainerResponseFilter>> containerResponseFilters, Set<Class<? extends ExceptionMapper>> exceptionMappers, Map<String, Set<PluginRestResource>> pluginRestResources, ObjectMapper objectMapper) {
        this.configuration = configuration;
        this.securityContextFactory = securityContextFactory;
        this.dynamicFeatures = dynamicFeatures;
        this.containerResponseFilters = containerResponseFilters;
        this.exceptionMappers = exceptionMappers;
        this.pluginRestResources = pluginRestResources;
        this.objectMapper = objectMapper;
    }

    protected void startUp() throws Exception {
        ExecutorService bossExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("restapi-boss-%d").build());
        ExecutorService workerExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("restapi-worker-%d").build());
        this.bootstrap = new ServerBootstrap((ChannelFactory)new NioServerSocketChannelFactory((Executor)bossExecutor, (Executor)workerExecutor));
        ResourceConfig rc = new ResourceConfig().property("org.graylog2.jersey.container.netty.baseUri", (Object)this.configuration.getRestListenUri()).registerClasses(new Class[]{JacksonPropertyExceptionMapper.class, AnyExceptionClassMapper.class, WebApplicationExceptionMapper.class});
        for (Class<? extends ExceptionMapper> clazz : this.exceptionMappers) {
            rc.registerClasses(new Class[]{clazz});
        }
        for (Class<? extends ExceptionMapper> clazz : this.dynamicFeatures) {
            rc.registerClasses(new Class[]{clazz});
        }
        for (Class<? extends ExceptionMapper> clazz : this.containerResponseFilters) {
            rc.registerClasses(new Class[]{clazz});
        }
        rc.register((Object)new JacksonJsonProvider(this.objectMapper)).registerFinder((ResourceFinder)new PackageNamesScanner(new String[]{"org.graylog2.rest.resources", "org.graylog2.radio.rest.resources", "org.graylog2.shared.rest.resources"}, true));
        if (this.configuration.isRestEnableGzip()) {
            EncodingFilter.enableFor((ResourceConfig)rc, (Class[])new Class[]{GZipEncoder.class});
        }
        if (this.configuration.isRestEnableCors()) {
            LOG.info("Enabling CORS for REST API");
            rc.register(CORSFilter.class);
        }
        rc.registerResources(this.prefixPluginResources("/plugins", this.pluginRestResources));
        if (LOG.isDebugEnabled()) {
            rc.register(PrintModelProcessor.class);
        }
        final NettyContainer jerseyHandler = (NettyContainer)ContainerFactory.createContainer(NettyContainer.class, (Application)rc);
        if (this.securityContextFactory != null) {
            LOG.info("Adding security context factory: <{}>", (Object)this.securityContextFactory);
            jerseyHandler.setSecurityContextFactory(this.securityContextFactory);
        } else {
            LOG.info("Not adding security context factory.");
        }
        this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
                pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
                pipeline.addLast("chunks", (ChannelHandler)new ChunkedWriteHandler());
                pipeline.addLast("jerseyHandler", (ChannelHandler)jerseyHandler);
                return pipeline;
            }
        });
        this.bootstrap.setOption("child.tcpNoDelay", (Object)true);
        this.bootstrap.setOption("child.keepAlive", (Object)true);
        this.bootstrap.bind((SocketAddress)new InetSocketAddress(this.configuration.getRestListenUri().getHost(), this.configuration.getRestListenUri().getPort()));
        LOG.info("Started REST API at <{}>", (Object)this.configuration.getRestListenUri());
    }

    private Set<Resource> prefixPluginResources(String pluginPrefix, Map<String, Set<PluginRestResource>> pluginResourceMap) {
        HashSet<Resource> result = new HashSet<Resource>();
        for (Map.Entry<String, Set<PluginRestResource>> entry : pluginResourceMap.entrySet()) {
            for (PluginRestResource pluginRestResource : entry.getValue()) {
                String path;
                StringBuilder resourcePath = new StringBuilder(pluginPrefix).append("/").append(entry.getKey());
                Path pathAnnotation = Resource.getPath(pluginRestResource.getClass());
                String string = path = pathAnnotation.value() == null ? "" : pathAnnotation.value();
                if (!path.startsWith("/")) {
                    resourcePath.append("/");
                }
                Resource.Builder resourceBuilder = Resource.builder(pluginRestResource.getClass()).path(resourcePath.append(path).toString());
                Resource resource = resourceBuilder.build();
                result.add(resource);
            }
        }
        return result;
    }

    protected void shutDown() throws Exception {
        LOG.info("Shutting down REST API at <{}>", (Object)this.configuration.getRestListenUri());
        this.bootstrap.releaseExternalResources();
        this.bootstrap.shutdown();
    }
}

