/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.initializers;

import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.inject.Inject;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import org.graylog2.periodical.Periodicals;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.shared.bindings.InstantiationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PeriodicalsService
extends AbstractIdleService {
    private static final Logger LOG = LoggerFactory.getLogger(PeriodicalsService.class);
    public static final String NAME = "Periodicals initializer";
    private final InstantiationService instantiationService;
    private final Periodicals periodicals;
    private final ServerStatus serverStatus;
    private final Set<Periodical> periodicalSet;

    @Inject
    public PeriodicalsService(InstantiationService instantiationService, Periodicals periodicals, ServerStatus serverStatus, Set<Periodical> periodicalSet) {
        this.instantiationService = instantiationService;
        this.periodicals = periodicals;
        this.serverStatus = serverStatus;
        this.periodicalSet = periodicalSet;
    }

    protected void startUp() throws Exception {
        LOG.info("Starting {} periodicals ...", (Object)this.periodicalSet.size());
        for (Periodical periodical : this.periodicalSet) {
            try {
                periodical.initialize();
                if (periodical.masterOnly() && !this.serverStatus.hasCapability(ServerStatus.Capability.MASTER)) {
                    LOG.info("Not starting [{}] periodical. Only started on graylog2-server master nodes.", (Object)periodical.getClass().getCanonicalName());
                    continue;
                }
                if (!periodical.startOnThisNode()) {
                    LOG.info("Not starting [{}] periodical. Not configured to run on this node.", (Object)periodical.getClass().getCanonicalName());
                    continue;
                }
                this.periodicals.registerAndStart(periodical);
            }
            catch (Exception e) {
                LOG.error("Could not initialize periodical.", (Throwable)e);
            }
        }
    }

    protected void shutDown() throws Exception {
        for (Periodical periodical : this.periodicals.getAllStoppedOnGracefulShutdown()) {
            LOG.info("Shutting down periodical [{}].", (Object)periodical.getClass().getCanonicalName());
            Stopwatch s = Stopwatch.createStarted();
            Map<Periodical, ScheduledFuture> futures = this.periodicals.getFutures();
            if (futures.containsKey(periodical)) {
                futures.get(periodical).cancel(false);
                s.stop();
                LOG.info("Shutdown of periodical [{}] complete, took <{}ms>.", (Object)periodical.getClass().getCanonicalName(), (Object)s.elapsed(TimeUnit.MILLISECONDS));
                continue;
            }
            LOG.error("Could not find periodical [{}] in futures list. Not stopping execution.", (Object)periodical.getClass().getCanonicalName());
        }
    }
}

