/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared;

import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.graylog2.plugin.Tools;
import org.graylog2.shared.bindings.GenericBindings;
import org.graylog2.shared.bindings.InstantiationService;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeRunner {
    private static final Logger LOG = LoggerFactory.getLogger(NodeRunner.class);

    protected static List<Module> getBindingsModules(InstantiationService instantiationService, Module ... specificModules) {
        ArrayList result = Lists.newArrayList();
        result.add(new GenericBindings(instantiationService));
        Reflections reflections = new Reflections("org.graylog2.shared.bindings", new Scanner[0]);
        for (Class type : reflections.getSubTypesOf(AbstractModule.class)) {
            if (type.equals(GenericBindings.class)) continue;
            try {
                Constructor constructor = type.getConstructor(new Class[0]);
                Module module = (Module)constructor.newInstance(new Object[0]);
                result.add(module);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                LOG.error("Unable to instantiate Module {}: {}", (Object)type, (Object)e);
            }
            catch (NoSuchMethodException e) {
                LOG.info("No constructor found for guice module {}", (Object)type);
            }
        }
        result.addAll(Arrays.asList(specificModules));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void savePidFile(String pidFile) {
        String pid = Tools.getPID();
        FileWriter pidFileWriter = null;
        try {
            if (pid == null || pid.isEmpty() || pid.equals("unknown")) {
                throw new Exception("Could not determine PID.");
            }
            pidFileWriter = new FileWriter(pidFile);
            IOUtils.write((String)pid, (Writer)pidFileWriter);
        }
        catch (Exception e) {
            try {
                LOG.error("Could not write PID file: " + e.getMessage(), (Throwable)e);
                System.exit(1);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(pidFileWriter);
                new File(pidFile).deleteOnExit();
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)pidFileWriter);
            new File(pidFile).deleteOnExit();
        }
        IOUtils.closeQuietly((Writer)pidFileWriter);
        new File(pidFile).deleteOnExit();
    }
}

