/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio.commands;

import com.google.common.util.concurrent.ServiceManager;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.airline.Command;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.graylog2.bootstrap.Main;
import org.graylog2.bootstrap.ServerBootstrap;
import org.graylog2.plugin.BaseConfiguration;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.radio.Configuration;
import org.graylog2.radio.bindings.PeriodicalBindings;
import org.graylog2.radio.bindings.RadioBindings;
import org.graylog2.radio.bindings.RadioInitializerBindings;
import org.graylog2.radio.cluster.Ping;
import org.graylog2.shared.bindings.ObjectMapperModule;
import org.graylog2.shared.bindings.RestApiBindings;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(name="radio", description="Start the Graylog radio")
public class Radio
extends ServerBootstrap {
    private static final Logger LOG = LoggerFactory.getLogger(Radio.class);
    private static final Configuration configuration = new Configuration();

    public Radio() {
        super("radio", (BaseConfiguration)configuration);
    }

    protected List<Module> getCommandBindings() {
        return Arrays.asList(new Module[]{new RadioBindings(configuration), new RadioInitializerBindings(), new PeriodicalBindings(), new ObjectMapperModule(), new RestApiBindings()});
    }

    protected List<Object> getCommandConfigurationBeans() {
        return Arrays.asList(new Object[]{configuration});
    }

    protected void startNodeRegistration(Injector injector) {
        Ping pinger = (Ping)injector.getInstance(Ping.class);
        pinger.run();
    }

    protected boolean validateConfiguration() {
        return true;
    }

    protected Class<? extends Runnable> shutdownHook() {
        return ShutdownHook.class;
    }

    protected Set<ServerStatus.Capability> capabilities() {
        return EnumSet.of(ServerStatus.Capability.RADIO);
    }

    static {
        configuration.setMessageJournalEnabled(false);
    }

    private static class ShutdownHook
    implements Runnable {
        private final ActivityWriter activityWriter;
        private final ServiceManager serviceManager;

        @Inject
        public ShutdownHook(ActivityWriter activityWriter, ServiceManager serviceManager) {
            this.activityWriter = activityWriter;
            this.serviceManager = serviceManager;
        }

        @Override
        public void run() {
            String msg = "SIGNAL received. Shutting down.";
            LOG.info(msg);
            this.activityWriter.write(new Activity(msg, Main.class));
            this.serviceManager.stopAsync().awaitStopped();
        }
    }
}

