/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.graylog2.radio.Configuration;
import org.graylog2.rest.models.system.buffers.responses.BuffersUtilizationSummary;
import org.graylog2.rest.models.system.buffers.responses.RingSummary;
import org.graylog2.rest.models.system.buffers.responses.SingleRingUtilization;
import org.graylog2.shared.buffers.ProcessBuffer;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="System/Buffers", description="Buffer information of this node.")
@Path(value="/system/buffers")
public class BuffersResource
extends RestResource {
    private final Configuration configuration;
    private final ProcessBuffer processBuffer;

    @Inject
    public BuffersResource(Configuration configuration, ProcessBuffer processBuffer) {
        this.configuration = configuration;
        this.processBuffer = processBuffer;
    }

    @GET
    @Timed
    @ApiOperation(value="Get current utilization of buffers and caches of this node.")
    @Produces(value={"application/json"})
    public BuffersUtilizationSummary utilization() {
        int ringSize = this.configuration.getRingSize();
        long inputSize = this.processBuffer.getUsage();
        long inputUtil = inputSize / (long)ringSize * 100L;
        return BuffersUtilizationSummary.create((RingSummary)RingSummary.create((SingleRingUtilization)SingleRingUtilization.create((long)inputSize, (long)inputUtil)));
    }
}

