/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio.bindings.providers;

import com.codahale.metrics.MetricRegistry;
import javax.inject.Inject;
import javax.inject.Provider;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.radio.Configuration;
import org.graylog2.radio.transports.RadioTransport;
import org.graylog2.radio.transports.amqp.AMQPProducer;
import org.graylog2.radio.transports.kafka.KafkaProducer;

public class RadioTransportProvider
implements Provider<RadioTransport> {
    private final Configuration configuration;
    private final MetricRegistry metricRegistry;
    private final ServerStatus serverStatus;

    @Inject
    public RadioTransportProvider(Configuration configuration, MetricRegistry metricRegistry, ServerStatus serverStatus) {
        this.configuration = configuration;
        this.metricRegistry = metricRegistry;
        this.serverStatus = serverStatus;
    }

    public RadioTransport get() {
        switch (this.configuration.getTransportType()) {
            case AMQP: {
                return new AMQPProducer(this.metricRegistry, this.configuration, this.serverStatus);
            }
            case KAFKA: {
                return new KafkaProducer(this.serverStatus, this.configuration, this.metricRegistry);
            }
        }
        throw new RuntimeException("Cannot map transport type to transport.");
    }
}

