/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio.bindings;

import com.google.inject.Module;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import java.io.File;
import java.lang.annotation.Annotation;
import org.graylog2.jersey.container.netty.SecurityContextFactory;
import org.graylog2.plugin.BaseConfiguration;
import org.graylog2.plugin.inject.Graylog2Module;
import org.graylog2.radio.Configuration;
import org.graylog2.radio.bindings.providers.RadioTransportProvider;
import org.graylog2.radio.buffers.processors.RadioProcessBufferProcessor;
import org.graylog2.radio.inputs.PersistedInputsImpl;
import org.graylog2.radio.security.RadioSecurityContextFactory;
import org.graylog2.radio.transports.RadioTransport;
import org.graylog2.radio.users.NullUserServiceImpl;
import org.graylog2.shared.buffers.processors.ProcessBufferProcessor;
import org.graylog2.shared.inputs.PersistedInputs;
import org.graylog2.shared.journal.NoopJournalModule;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.graylog2.shared.system.activities.NullActivityWriter;
import org.graylog2.shared.users.UserService;

public class RadioBindings
extends Graylog2Module {
    private final Configuration configuration;

    public RadioBindings(Configuration configuration) {
        this.configuration = configuration;
    }

    protected void configure() {
        this.bindSingletons();
        this.bindTransport();
        this.bind(ProcessBufferProcessor.class).to(RadioProcessBufferProcessor.class);
        this.bindInterfaces();
    }

    private void bindInterfaces() {
        this.bind(ActivityWriter.class).to(NullActivityWriter.class);
        this.bind(PersistedInputs.class).to(PersistedInputsImpl.class);
        this.bind(UserService.class).to(NullUserServiceImpl.class);
        this.bind(SecurityContextFactory.class).to(RadioSecurityContextFactory.class);
    }

    private void bindSingletons() {
        this.bind(Configuration.class).toInstance((Object)this.configuration);
        this.bind(BaseConfiguration.class).toInstance((Object)this.configuration);
        this.install((Module)new NoopJournalModule());
        this.bind(File.class).annotatedWith((Annotation)Names.named((String)"message_journal_dir")).toProvider(Providers.of(null));
        this.bind(String[].class).annotatedWith((Annotation)Names.named((String)"RestControllerPackages")).toInstance((Object)new String[]{"org.graylog2.radio.rest.resources", "org.graylog2.shared.rest.resources"});
    }

    private void bindTransport() {
        this.bind(RadioTransport.class).toProvider(RadioTransportProvider.class);
    }
}

