/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio.cluster;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Named;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.rest.models.radio.requests.PingRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ping
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(Ping.class);
    private static final MediaType CONTENT_TYPE = MediaType.parse((String)"application/json");
    private final ObjectMapper objectMapper;
    private final OkHttpClient httpClient;
    private final NodeId nodeId;
    private final URI serverUri;
    private final URI ourUri;

    @Inject
    public Ping(ObjectMapper objectMapper, @Named(value="systemHttpClient") OkHttpClient httpClient, @Named(value="rest_transport_uri") URI ourUri, @Named(value="graylog2_server_uri") URI serverUri, NodeId nodeId) {
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper);
        this.httpClient = (OkHttpClient)Preconditions.checkNotNull((Object)httpClient);
        this.nodeId = (NodeId)Preconditions.checkNotNull((Object)nodeId);
        this.ourUri = (URI)Preconditions.checkNotNull((Object)ourUri);
        this.serverUri = (URI)Preconditions.checkNotNull((Object)serverUri);
    }

    public void ping() throws IOException {
        PingRequest pingRequest = PingRequest.create((String)this.ourUri.toString());
        URI uri = this.serverUri.resolve("/system/radios/" + this.nodeId + "/ping");
        Request request = new Request.Builder().url(uri.toURL()).put(RequestBody.create((MediaType)CONTENT_TYPE, (byte[])this.objectMapper.writeValueAsBytes((Object)pingRequest))).build();
        Response r = this.httpClient.newCall(request).execute();
        if (!r.isSuccessful()) {
            throw new RuntimeException("Expected successful HTTP response [2xx] but got [" + r.code() + "]. Request was " + request.urlString());
        }
    }

    @Override
    public void run() {
        try {
            this.ping();
        }
        catch (IOException e) {
            LOG.error("Pinging the master node failed: ", (Throwable)e);
        }
    }
}

