/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio.cluster;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.UriBuilder;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.rest.models.radio.responses.PersistedInputsResponse;
import org.graylog2.rest.models.radio.responses.PersistedInputsSummaryResponse;
import org.graylog2.rest.models.radio.responses.RegisterInputResponse;
import org.graylog2.rest.models.system.inputs.requests.RegisterInputRequest;

public class InputService {
    private final ObjectMapper mapper = new ObjectMapper();
    private final OkHttpClient httpclient;
    private final URI serverUrl;
    private final NodeId nodeId;

    @Inject
    public InputService(@Named(value="systemHttpClient") OkHttpClient httpclient, @Named(value="graylog2_server_uri") URI serverUrl, NodeId nodeId) {
        this.httpclient = (OkHttpClient)Preconditions.checkNotNull((Object)httpclient);
        this.serverUrl = (URI)Preconditions.checkNotNull((Object)serverUrl);
        this.nodeId = (NodeId)Preconditions.checkNotNull((Object)nodeId);
    }

    public List<PersistedInputsResponse> getPersistedInputs() throws IOException {
        URI uri = UriBuilder.fromUri((URI)this.serverUrl).path("/system/radios/{radioId}/inputs").build(new Object[]{this.nodeId.toString()});
        Request request = new Request.Builder().header("Content-Type", "application/json").get().url(uri.toString()).build();
        Response r = this.httpclient.newCall(request).execute();
        if (!r.isSuccessful()) {
            throw new RuntimeException("Expected successful HTTP response [2xx] for list of persisted input but got [" + r.code() + "].");
        }
        PersistedInputsSummaryResponse persistedInputsResponse = (PersistedInputsSummaryResponse)this.mapper.readValue(r.body().byteStream(), PersistedInputsSummaryResponse.class);
        return persistedInputsResponse.inputs();
    }

    public PersistedInputsResponse getPersistedInput(String inputId) throws IOException {
        for (PersistedInputsResponse inputSummaryResponse : this.getPersistedInputs()) {
            if (!inputSummaryResponse.id().equals(inputId)) continue;
            return inputSummaryResponse;
        }
        return null;
    }

    public RegisterInputResponse registerInCluster(MessageInput input) throws ExecutionException, InterruptedException, IOException {
        URI uri = UriBuilder.fromUri((URI)this.serverUrl).path("/system/radios/{radioId}/inputs").build(new Object[]{this.nodeId.toString()});
        RegisterInputRequest rir = RegisterInputRequest.create((String)input.getId(), (String)input.getTitle(), (String)input.getType(), (Map)input.getConfiguration().getSource(), (String)this.nodeId.toString(), (String)input.getCreatorUserId());
        Request request = new Request.Builder().post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (byte[])this.mapper.writeValueAsBytes((Object)rir))).url(uri.toString()).build();
        Response r = this.httpclient.newCall(request).execute();
        RegisterInputResponse registerInputResponse = (RegisterInputResponse)this.mapper.readValue(r.body().byteStream(), RegisterInputResponse.class);
        input.setPersistId(registerInputResponse.persistId());
        if (!r.isSuccessful()) {
            throw new RuntimeException("Expected HTTP response [2xx] for input registration but got [" + r.code() + "].");
        }
        return registerInputResponse;
    }

    public void unregisterInCluster(MessageInput input) throws ExecutionException, InterruptedException, IOException {
        URI uri = UriBuilder.fromUri((URI)this.serverUrl).path("/system/radios/{radioId}/inputs/{inputId}").build(new Object[]{this.nodeId.toString(), input.getPersistId()});
        Request request = new Request.Builder().header("Content-Type", "application/json").delete().url(uri.toString()).build();
        Response r = this.httpclient.newCall(request).execute();
        if (!r.isSuccessful()) {
            throw new RuntimeException("Expected HTTP response [2xx] for input unregistration but got [" + r.code() + "].");
        }
    }
}

