/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio.inputs;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationException;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.radio.cluster.InputService;
import org.graylog2.rest.models.radio.responses.PersistedInputsResponse;
import org.graylog2.rest.models.radio.responses.RegisterInputResponse;
import org.graylog2.shared.inputs.MessageInputFactory;
import org.graylog2.shared.inputs.NoSuchInputTypeException;
import org.graylog2.shared.inputs.PersistedInputs;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistedInputsImpl
implements PersistedInputs {
    private static final Logger LOG = LoggerFactory.getLogger(PersistedInputsImpl.class);
    private final InputService inputService;
    private final MessageInputFactory messageInputFactory;

    @Inject
    public PersistedInputsImpl(InputService inputService, MessageInputFactory messageInputFactory) {
        this.inputService = inputService;
        this.messageInputFactory = messageInputFactory;
    }

    private MessageInput getMessageInput(PersistedInputsResponse isr) {
        MessageInput input;
        try {
            Configuration inputConfig = new Configuration(isr.configuration());
            input = this.messageInputFactory.create(isr.type(), inputConfig);
            input.setTitle(isr.title());
            input.setCreatorUserId(isr.creatorUserId());
            input.setPersistId(isr.id());
            input.setCreatedAt(new DateTime((Object)isr.createdAt(), DateTimeZone.UTC));
            input.setGlobal(isr.global());
            input.checkConfiguration();
        }
        catch (NoSuchInputTypeException e) {
            LOG.warn("Cannot launch persisted input. No such type [{}]. Error: {}", (Object)isr.type(), (Object)e);
            return null;
        }
        catch (ConfigurationException e) {
            LOG.error("Missing or invalid input input configuration.", (Throwable)e);
            return null;
        }
        return input;
    }

    public Iterator<MessageInput> iterator() {
        List<PersistedInputsResponse> response;
        ArrayList result = Lists.newArrayList();
        try {
            response = this.inputService.getPersistedInputs();
        }
        catch (IOException e) {
            LOG.error("Unable to get persisted inputs: ", (Throwable)e);
            return result.iterator();
        }
        for (PersistedInputsResponse isr : response) {
            MessageInput messageInput = this.getMessageInput(isr);
            if (messageInput == null) continue;
            LOG.debug("Loaded message input {}", (Object)messageInput);
            result.add(messageInput);
        }
        return result.iterator();
    }

    public MessageInput get(String id) {
        try {
            return this.getMessageInput(this.inputService.getPersistedInput(id));
        }
        catch (IOException e) {
            LOG.warn("Unable to fetch Input information for id [{}]: {}", (Object)id, (Object)e);
            return null;
        }
    }

    public boolean add(MessageInput input) {
        try {
            RegisterInputResponse response = this.inputService.registerInCluster(input);
            if (response != null) {
                input.setPersistId(response.persistId());
            }
        }
        catch (Exception e) {
            LOG.error("Could not register input in Graylog cluster. It will be lost on next restart of this radio node.", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean remove(Object o) {
        if (o instanceof MessageInput) {
            MessageInput messageInput = (MessageInput)o;
            try {
                this.inputService.unregisterInCluster(messageInput);
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                LOG.error("Could not unregister input in Graylog2 cluster: ", (Throwable)e);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean update(String id, MessageInput newInput) {
        return false;
    }
}

