/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio.rest.resources.system.inputs;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.graylog2.plugin.IOState;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationException;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.radio.rest.resources.RestResource;
import org.graylog2.rest.models.system.inputs.requests.InputLaunchRequest;
import org.graylog2.rest.models.system.inputs.responses.InputStateSummary;
import org.graylog2.rest.models.system.inputs.responses.InputSummary;
import org.graylog2.rest.models.system.inputs.responses.InputsList;
import org.graylog2.shared.inputs.InputLauncher;
import org.graylog2.shared.inputs.InputRegistry;
import org.graylog2.shared.inputs.MessageInputFactory;
import org.graylog2.shared.inputs.NoSuchInputTypeException;
import org.graylog2.shared.inputs.PersistedInputs;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/system/inputs")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class InputsResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(InputsResource.class);
    private final InputRegistry inputRegistry;
    private final MessageInputFactory messageInputFactory;
    private final InputLauncher inputLauncher;
    private final PersistedInputs persistedInputs;

    @Inject
    public InputsResource(InputRegistry inputRegistry, MessageInputFactory messageInputFactory, InputLauncher inputLauncher, PersistedInputs persistedInputs) {
        this.inputRegistry = inputRegistry;
        this.messageInputFactory = messageInputFactory;
        this.inputLauncher = inputLauncher;
        this.persistedInputs = persistedInputs;
    }

    @GET
    @Timed
    public InputsList list() {
        HashSet inputStates = Sets.newHashSet();
        for (IOState inputState : this.inputRegistry.getInputStates()) {
            MessageInput input = (MessageInput)inputState.getStoppable();
            inputStates.add(InputStateSummary.create((String)input.getId(), (String)inputState.getState().toString(), (DateTime)inputState.getStartedAt(), (String)inputState.getDetailedMessage(), (InputSummary)InputSummary.create((String)input.getTitle(), (String)input.getId(), (Boolean)input.isGlobal(), (String)input.getName(), (String)input.getContentPack(), (String)input.getId(), (DateTime)input.getCreatedAt(), (String)input.getType(), (String)input.getCreatorUserId(), (Map)input.getAttributesWithMaskedPasswords(), (Map)input.getStaticFields())));
        }
        return InputsList.create((Set)inputStates);
    }

    @GET
    @Timed
    @Path(value="/{inputId}")
    public InputSummary single(@PathParam(value="inputId") String inputId) {
        MessageInput input = this.inputRegistry.getRunningInput(inputId);
        if (input == null) {
            LOG.info("Input [{}]\u00a0not found.", (Object)inputId);
            throw new NotFoundException();
        }
        return InputSummary.create((String)input.getTitle(), (String)input.getPersistId(), (Boolean)input.isGlobal(), (String)input.getName(), (String)input.getContentPack(), (String)input.getId(), (DateTime)input.getCreatedAt(), (String)input.getClass().getCanonicalName(), (String)input.getCreatorUserId(), (Map)input.getAttributesWithMaskedPasswords(), (Map)input.getStaticFields());
    }

    @POST
    @Timed
    public Response launch(String body) {
        MessageInput input;
        InputLaunchRequest lr;
        try {
            lr = (InputLaunchRequest)this.objectMapper.readValue(body, InputLaunchRequest.class);
        }
        catch (IOException e) {
            LOG.error("Error while parsing JSON", (Throwable)e);
            throw new BadRequestException((Throwable)e);
        }
        Configuration inputConfig = new Configuration(lr.configuration());
        try {
            input = this.messageInputFactory.create(lr.type(), inputConfig);
            input.setTitle(lr.title());
            input.setCreatedAt(Tools.iso8601());
            input.setGlobal(Boolean.valueOf(lr.global()));
            input.checkConfiguration();
        }
        catch (NoSuchInputTypeException e) {
            LOG.error("There is no such input type registered.", (Throwable)e);
            throw new BadRequestException((Throwable)e);
        }
        catch (ConfigurationException e) {
            LOG.error("Missing or invalid input configuration.", (Throwable)e);
            throw new BadRequestException((Throwable)e);
        }
        String inputId = UUID.randomUUID().toString();
        input.setPersistId(inputId);
        if (input.isExclusive() && this.inputRegistry.hasTypeRunning(input.getClass())) {
            LOG.error("Type is exclusive and already has input running.");
            throw new BadRequestException();
        }
        input.initialize();
        this.inputLauncher.launch(input);
        ImmutableMap result = ImmutableMap.of((Object)"input_id", (Object)inputId, (Object)"persist_id", (Object)inputId);
        return Response.accepted().entity((Object)result).build();
    }

    @DELETE
    @Timed
    @Path(value="/{inputId}")
    public Response terminate(@PathParam(value="inputId") String inputId) {
        MessageInput input = this.inputRegistry.getRunningInput(inputId);
        if (input == null) {
            LOG.info("Cannot terminate input. Input not found.");
            throw new NotFoundException();
        }
        LOG.info("Attempting to terminate input [" + input.getName() + "]. Reason: REST request.");
        this.inputRegistry.remove(input);
        if (!input.isGlobal().booleanValue()) {
            this.persistedInputs.remove((Object)input);
        }
        LOG.info("Terminated input [" + input.getName() + "]. Reason: REST request.");
        return Response.accepted().build();
    }

    @POST
    @Timed
    @Path(value="/{inputId}/launch")
    public Response launchExisting(@PathParam(value="inputId") String inputId) {
        IOState inputState = this.inputRegistry.getInputState(inputId);
        if (inputState == null || inputState.getState() != IOState.Type.RUNNING) {
            MessageInput input;
            if (inputState == null) {
                input = this.persistedInputs.get(inputId);
                if (input != null) {
                    input.initialize();
                }
            } else {
                input = (MessageInput)inputState.getStoppable();
            }
            if (input == null) {
                String message = "Cannot launch input <" + inputId + ">. Input not found.";
                LOG.info(message);
                throw new NotFoundException(message);
            }
            LOG.info("Launching existing input [" + input.getName() + "]. Reason: REST request.");
            this.inputLauncher.launch(input);
            LOG.info("Launched existing input [" + input.getName() + "]. Reason: REST request.");
        }
        return Response.accepted().build();
    }

    @POST
    @Timed
    @Path(value="/{inputId}/stop")
    public Response stop(@PathParam(value="inputId") String inputId) {
        MessageInput input = this.inputRegistry.getRunningInput(inputId);
        if (input == null) {
            LOG.info("Cannot stop input. Input not found.");
            throw new NotFoundException();
        }
        LOG.info("Stopping input [" + input.getName() + "]. Reason: REST request.");
        this.inputRegistry.stop(input);
        LOG.info("Stopped input [" + input.getName() + "]. Reason: REST request.");
        return Response.accepted().build();
    }

    @POST
    @Timed
    @Path(value="/{inputId}/restart")
    public Response restart(@PathParam(value="inputId") String inputId) {
        this.stop(inputId);
        this.launchExisting(inputId);
        return Response.accepted().build();
    }
}

