/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio.rest.resources.system;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import org.graylog2.radio.rest.resources.RestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/system/metrics")
public class MetricsResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsResource.class);
    @Inject
    private MetricRegistry metricRegistry;

    @GET
    @Timed
    @Produces(value={"application/json"})
    public MetricRegistry metrics() {
        return this.metricRegistry;
    }

    @GET
    @Timed
    @Path(value="/names")
    @Produces(value={"application/json"})
    public String metricNames() {
        HashMap result = Maps.newHashMap();
        result.put("names", this.metricRegistry.getNames());
        return this.json(result);
    }

    @GET
    @Timed
    @Path(value="/{metricName}")
    @Produces(value={"application/json"})
    public Metric singleMetric(@PathParam(value="metricName") String metricName) {
        Metric metric = (Metric)this.metricRegistry.getMetrics().get(metricName);
        if (metric == null) {
            LOG.debug("I do not have a metric called [{}], returning 404.", (Object)metricName);
            throw new WebApplicationException(404);
        }
        return metric;
    }

    @POST
    @Timed
    @Path(value="/multiple")
    public String multipleMetrics(MetricsReadRequest request) {
        Map metrics = this.metricRegistry.getMetrics();
        ArrayList metricsList = Lists.newArrayList();
        if (request.metrics == null) {
            throw new BadRequestException("Metrics cannot be empty");
        }
        for (String name : request.metrics) {
            Metric metric = (Metric)metrics.get(name);
            if (metric == null) continue;
            metricsList.add(this.getMetricMap(name, metric));
        }
        HashMap result = Maps.newHashMap();
        result.put("metrics", metricsList);
        result.put("total", metricsList.size());
        return this.json(result);
    }

    private Map<String, Object> getMetricMap(String metricName, Metric metric) {
        String type = metric.getClass().getSimpleName().toLowerCase();
        if (type.isEmpty()) {
            type = "gauge";
        }
        HashMap metricMap = Maps.newHashMap();
        metricMap.put("full_name", metricName);
        metricMap.put("name", metricName.substring(metricName.lastIndexOf(".") + 1));
        metricMap.put("type", type);
        if (metric instanceof Timer) {
            metricMap.put("metric", this.buildTimerMap((Timer)metric));
        } else if (metric instanceof Meter) {
            metricMap.put("metric", this.buildMeterMap((Meter)metric));
        } else if (metric instanceof Histogram) {
            metricMap.put("metric", this.buildHistogramMap((Histogram)metric));
        } else {
            metricMap.put("metric", metric);
        }
        return metricMap;
    }

    @GET
    @Timed
    @Path(value="/namespace/{namespace}")
    @Produces(value={"application/json"})
    public String byNamespace(@PathParam(value="namespace") String namespace) {
        ArrayList metrics = Lists.newArrayList();
        for (Map.Entry e : this.metricRegistry.getMetrics().entrySet()) {
            if (!((String)e.getKey()).startsWith(namespace)) continue;
            try {
                String type = ((Metric)e.getValue()).getClass().getSimpleName().toLowerCase();
                String metricName = (String)e.getKey();
                if (type.isEmpty()) {
                    type = "gauge";
                }
                HashMap metric = Maps.newHashMap();
                metric.put("full_name", metricName);
                metric.put("name", metricName.substring(metricName.lastIndexOf(".") + 1));
                metric.put("type", type);
                if (e.getValue() instanceof Timer) {
                    metric.put("metric", this.buildTimerMap((Timer)e.getValue()));
                } else if (e.getValue() instanceof Meter) {
                    metric.put("metric", this.buildMeterMap((Meter)e.getValue()));
                } else if (e.getValue() instanceof Histogram) {
                    metric.put("metric", this.buildHistogramMap((Histogram)e.getValue()));
                } else {
                    metric.put("metric", e.getValue());
                }
                metrics.add(metric);
            }
            catch (Exception ex) {
                LOG.warn("Could not read metric in namespace list.", (Throwable)ex);
            }
        }
        if (metrics.isEmpty()) {
            LOG.debug("No metrics with namespace [{}] found, returning 404.", (Object)namespace);
            throw new WebApplicationException(404);
        }
        HashMap result = Maps.newHashMap();
        result.put("metrics", metrics);
        result.put("total", metrics.size());
        return this.json(result);
    }

    @JsonAutoDetect
    public static class MetricsReadRequest {
        public String[] metrics;
    }
}

