/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.graylog2.plugin.buffers.InputBuffer;
import org.graylog2.radio.Configuration;
import org.graylog2.radio.rest.resources.RestResource;
import org.graylog2.shared.buffers.ProcessBuffer;

@Path(value="/system/buffers")
public class BuffersResource
extends RestResource {
    private final Configuration configuration;
    private final InputBuffer inputBuffer;
    private final ProcessBuffer processBuffer;

    @Inject
    public BuffersResource(Configuration configuration, InputBuffer inputBuffer, ProcessBuffer processBuffer) {
        this.configuration = configuration;
        this.inputBuffer = inputBuffer;
        this.processBuffer = processBuffer;
    }

    @GET
    @Timed
    @Produces(value={"application/json"})
    public String utilization() {
        HashMap result = Maps.newHashMap();
        result.put("buffers", this.buffers());
        return this.json(result);
    }

    private Map<String, Object> buffers() {
        HashMap buffers = Maps.newHashMap();
        HashMap input = Maps.newHashMap();
        HashMap process = Maps.newHashMap();
        int inputBufferCapacity = this.configuration.getInputBufferRingSize();
        long inputSize = this.inputBuffer.size();
        float inputUtil = (float)inputSize / (float)inputBufferCapacity * 100.0f;
        input.put("utilization_percent", Float.valueOf(inputUtil));
        input.put("utilization", inputSize);
        buffers.put("input", input);
        int processBufferCapacity = this.configuration.getRingSize();
        long processSize = this.processBuffer.size();
        float processUtil = (float)processSize / (float)processBufferCapacity * 100.0f;
        process.put("utilization_percent", Float.valueOf(processUtil));
        process.put("utilization", processSize);
        buffers.put("process", process);
        return buffers;
    }
}

