/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio.cluster;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Request;
import com.ning.http.client.Response;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.UriBuilder;
import org.graylog2.plugin.ServerStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ping {
    private static final Logger LOG = LoggerFactory.getLogger(Ping.class);

    public static void ping(AsyncHttpClient client, URI server, URI ourUri, String radioId) throws IOException, ExecutionException, InterruptedException {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode rootNode = mapper.createObjectNode();
        rootNode.put("rest_transport_address", ourUri.toString());
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)server);
        uriBuilder.path("/system/radios/" + radioId + "/ping");
        Request request = client.preparePut(uriBuilder.build(new Object[0]).toString()).setHeader("Content-Type", "application/json").setBody(rootNode.toString()).build();
        ListenableFuture f = client.executeRequest(request);
        Response r = (Response)f.get();
        if (r.getStatusCode() > 299) {
            throw new RuntimeException("Expected ping HTTP response OK but got [" + r.getStatusCode() + "]. Request was " + request.getUrl());
        }
    }

    public static class Pinger
    implements Runnable {
        private final AsyncHttpClient httpClient;
        private final String nodeId;
        private final URI serverUri;
        private final URI ourUri;

        @Inject
        public Pinger(AsyncHttpClient httpClient, @Named(value="rest_transport_uri") URI ourUri, @Named(value="graylog2_server_uri") URI serverUri, ServerStatus serverStatus) {
            this.httpClient = httpClient;
            this.nodeId = serverStatus.getNodeId().toString();
            this.ourUri = ourUri;
            this.serverUri = serverUri;
        }

        @Override
        public void run() {
            this.ping();
        }

        public void ping() {
            LOG.debug("Updating (ping) this radio instance [{}] in the Graylog cluster at [{}]", (Object)this.nodeId, (Object)this.serverUri);
            try {
                Ping.ping(this.httpClient, this.serverUri, this.ourUri, this.nodeId);
            }
            catch (Exception e) {
                LOG.error("Cluster ping failed.", (Throwable)e);
            }
        }
    }
}

