/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio.transports.kafka;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.inject.Inject;
import kafka.javaapi.producer.Producer;
import kafka.producer.KeyedMessage;
import kafka.producer.ProducerConfig;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.RadioMessage;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.radio.Configuration;
import org.graylog2.radio.transports.RadioTransport;
import org.msgpack.MessagePack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaProducer
implements RadioTransport {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaProducer.class);
    public static final String KAFKA_TOPIC = "graylog2-radio-messages";
    private final Producer<byte[], byte[]> producer;
    private final MessagePack pack = new MessagePack();
    private final Meter incomingMessages;
    private final Meter rejectedMessages;
    private final Timer processTime;

    @Inject
    public KafkaProducer(ServerStatus serverStatus, Configuration configuration, MetricRegistry metricRegistry) {
        Properties props = new Properties();
        props.put("metadata.broker.list", configuration.getKafkaBrokers());
        props.put("partitioner.class", "kafka.producer.DefaultPartitioner");
        props.put("serializer.class", "kafka.serializer.DefaultEncoder");
        props.put("request.required.acks", String.valueOf(configuration.getKafkaRequiredAcks()));
        props.put("client.id", "graylog2-radio-" + serverStatus.getNodeId().toString());
        props.put("producer.type", configuration.getKafkaProducerType());
        props.put("queue.buffering.max.ms", String.valueOf(configuration.getKafkaBatchMaxWaitMs()));
        props.put("batch.num.messages", String.valueOf(configuration.getKafkaBatchSize()));
        ProducerConfig config = new ProducerConfig(props);
        this.producer = new Producer(config);
        this.incomingMessages = metricRegistry.meter(MetricRegistry.name(KafkaProducer.class, (String[])new String[]{"incomingMessages"}));
        this.rejectedMessages = metricRegistry.meter(MetricRegistry.name(KafkaProducer.class, (String[])new String[]{"rejectedMessages"}));
        this.processTime = metricRegistry.timer(MetricRegistry.name(KafkaProducer.class, (String[])new String[]{"processTime"}));
    }

    @Override
    public void send(Message msg) {
        try (Timer.Context context = this.processTime.time();){
            this.incomingMessages.mark();
            KeyedMessage data = new KeyedMessage(KAFKA_TOPIC, (Object)msg.getId().getBytes(StandardCharsets.UTF_8), (Object)RadioMessage.serialize((MessagePack)this.pack, (Message)msg));
            this.producer.send(data);
        }
        catch (IOException e) {
            LOG.error("Could not serialize message.", (Throwable)e);
            this.rejectedMessages.mark();
        }
    }
}

