/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio.transports.amqp;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.MessageProperties;
import java.io.IOException;
import javax.inject.Inject;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.RadioMessage;
import org.graylog2.radio.Configuration;
import org.msgpack.MessagePack;

public class AMQPSender {
    private final String hostname;
    private final int port;
    private final String vHost;
    private final String username;
    private final String password;
    private final String queueName;
    private final String queueType;
    private final String exchangeName;
    private final String routingKey;
    private final boolean amqpPersistentMessagesEnabled;
    private Connection connection;
    private Channel channel;
    private final MessagePack pack;

    public AMQPSender(String hostname, int port, String vHost, String username, String password, String queueName, String queueType, String exchangeName, String routingKey, boolean amqpPersistentMessagesEnabled) {
        this.queueName = queueName;
        this.queueType = queueType;
        this.exchangeName = exchangeName;
        this.routingKey = routingKey;
        this.amqpPersistentMessagesEnabled = amqpPersistentMessagesEnabled;
        this.pack = new MessagePack();
        this.hostname = hostname;
        this.port = port;
        this.vHost = vHost;
        this.username = username;
        this.password = password;
    }

    @Inject
    public AMQPSender(Configuration configuration) {
        this(configuration.getAmqpHostname(), configuration.getAmqpPort(), configuration.getAmqpVirtualHost(), configuration.getAmqpUsername(), configuration.getAmqpPassword(), configuration.getAmqpQueueName(), configuration.getAmqpQueueType(), configuration.getAmqpExchangeName(), configuration.getAmqpRoutingKey(), configuration.isAmqpPersistentMessagesEnabled());
    }

    public void send(Message msg) throws IOException {
        if (!this.isConnected()) {
            this.connect();
        }
        byte[] body = RadioMessage.serialize((MessagePack)this.pack, (Message)msg);
        this.channel.basicPublish(this.exchangeName, this.routingKey, true, this.amqpPersistentMessagesEnabled ? MessageProperties.MINIMAL_PERSISTENT_BASIC : MessageProperties.MINIMAL_BASIC, body);
    }

    public void connect() throws IOException {
        ConnectionFactory factory = new ConnectionFactory();
        factory.setHost(this.hostname);
        factory.setPort(this.port);
        factory.setVirtualHost(this.vHost);
        if (this.username != null && !this.username.isEmpty() && this.password != null && !this.password.isEmpty()) {
            factory.setUsername(this.username);
            factory.setPassword(this.password);
        }
        this.connection = factory.newConnection();
        this.channel = this.connection.createChannel();
        this.channel.queueDeclare(this.queueName, true, false, false, null);
        this.channel.exchangeDeclare(this.exchangeName, this.queueType, false, false, null);
        this.channel.queueBind(this.queueName, this.exchangeName, this.routingKey);
    }

    public boolean isConnected() {
        return this.connection != null && this.connection.isOpen() && this.channel != null && this.channel.isOpen();
    }

    public void close() throws IOException {
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close();
        }
        if (this.connection != null && this.connection.isOpen()) {
            this.connection.close();
        }
    }
}

