/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.codahale.metrics.jvm.ThreadDump;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.Tools;
import org.graylog2.radio.RadioVersion;
import org.graylog2.radio.rest.resources.RestResource;
import org.joda.time.DateTime;

@Path(value="/system")
public class SystemResource
extends RestResource {
    @Inject
    private ServerStatus serverStatus;

    @GET
    @Timed
    @Produces(value={"application/json"})
    public String system() {
        HashMap result = Maps.newHashMap();
        result.put("facility", "graylog2-radio");
        result.put("server_id", this.serverStatus.getNodeId().toString());
        result.put("version", RadioVersion.VERSION.toString());
        result.put("started_at", Tools.getISO8601String((DateTime)this.serverStatus.getStartedAt()));
        result.put("hostname", Tools.getLocalCanonicalHostname());
        result.put("lifecycle", this.serverStatus.getLifecycle().getDescription().toLowerCase());
        result.put("lb_status", this.serverStatus.getLifecycle().getLoadbalancerStatus().toString().toLowerCase());
        return this.json(result);
    }

    @GET
    @Timed
    @Path(value="/jvm")
    @Produces(value={"application/json"})
    public String jvm() {
        Runtime runtime = Runtime.getRuntime();
        HashMap result = Maps.newHashMap();
        result.put("free_memory", this.bytesToValueMap(runtime.freeMemory()));
        result.put("max_memory", this.bytesToValueMap(runtime.maxMemory()));
        result.put("total_memory", this.bytesToValueMap(runtime.totalMemory()));
        result.put("used_memory", this.bytesToValueMap(runtime.totalMemory() - runtime.freeMemory()));
        result.put("node_id", this.serverStatus.getNodeId().toString());
        result.put("pid", Tools.getPID());
        result.put("info", Tools.getSystemInformation());
        return this.json(result);
    }

    @GET
    @Timed
    @Path(value="/threaddump")
    @Produces(value={"text/plain"})
    public String threaddump() {
        ThreadDump threadDump = new ThreadDump(ManagementFactory.getThreadMXBean());
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        threadDump.dump((OutputStream)output);
        return new String(output.toByteArray(), StandardCharsets.UTF_8);
    }
}

