/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.lifecycles.LoadBalancerStatus;
import org.graylog2.radio.rest.resources.RestResource;

@Path(value="/system/lbstatus")
public class LoadBalancerStatusResource
extends RestResource {
    @Inject
    private ServerStatus serverStatus;

    @GET
    @Timed
    @Produces(value={"text/plain"})
    public Response status() {
        LoadBalancerStatus lbStatus = this.serverStatus.getLifecycle().getLoadbalancerStatus();
        Response.Status status = lbStatus == LoadBalancerStatus.ALIVE ? Response.Status.OK : Response.Status.SERVICE_UNAVAILABLE;
        return Response.status((Response.Status)status).entity((Object)lbStatus.toString().toUpperCase()).build();
    }

    @PUT
    @Timed
    @Produces(value={"application/json"})
    @Path(value="/override/{status}")
    public Response override(@PathParam(value="status") String status) {
        LoadBalancerStatus lbStatus;
        try {
            lbStatus = LoadBalancerStatus.valueOf((String)status.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        switch (lbStatus) {
            case DEAD: {
                this.serverStatus.overrideLoadBalancerDead();
                break;
            }
            case ALIVE: {
                this.serverStatus.overrideLoadBalancerAlive();
            }
        }
        return Response.ok().build();
    }
}

