/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.graylog2.radio.Configuration;
import org.graylog2.radio.rest.resources.RestResource;
import org.graylog2.shared.buffers.ProcessBuffer;

@Path(value="/system/buffers")
public class BuffersResource
extends RestResource {
    private final Configuration configuration;
    private final ProcessBuffer processBuffer;

    @Inject
    public BuffersResource(Configuration configuration, ProcessBuffer processBuffer) {
        this.configuration = configuration;
        this.processBuffer = processBuffer;
    }

    @GET
    @Timed
    @Produces(value={"application/json"})
    public String utilization() {
        HashMap result = Maps.newHashMap();
        result.put("buffers", this.buffers());
        result.put("master_caches", this.masterCaches());
        return this.json(result);
    }

    private Map<String, Object> masterCaches() {
        HashMap caches = Maps.newHashMap();
        HashMap input = Maps.newHashMap();
        input.put("size", 0);
        caches.put("input", input);
        return caches;
    }

    private Map<String, Object> buffers() {
        HashMap buffers = Maps.newHashMap();
        HashMap input = Maps.newHashMap();
        int ringSize = this.configuration.getRingSize();
        long inputSize = this.processBuffer.size();
        long inputUtil = inputSize / (long)ringSize * 100L;
        input.put("utilization_percent", inputUtil);
        input.put("utilization", inputSize);
        buffers.put("input", input);
        return buffers;
    }
}

