/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio.inputs;

import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import org.graylog2.plugin.IOState;
import org.graylog2.plugin.events.inputs.IOStateChangedEvent;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.radio.cluster.InputService;
import org.graylog2.shared.inputs.InputRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStateListener {
    private static final Logger LOG = LoggerFactory.getLogger(InputStateListener.class);
    private final InputService inputService;
    private final InputRegistry inputRegistry;

    @Inject
    public InputStateListener(InputService inputService, InputRegistry inputRegistry) {
        this.inputService = inputService;
        this.inputRegistry = inputRegistry;
    }

    @Subscribe
    public void inputStateChanged(IOStateChangedEvent<MessageInput> event) {
        IOState state = event.changedState();
        MessageInput input = (MessageInput)state.getStoppable();
        try {
            if (!input.isGlobal().booleanValue() && event.newState() == IOState.Type.TERMINATED) {
                this.inputService.unregisterInCluster(input);
            }
        }
        catch (Exception e) {
            LOG.error("Could not unregister input [{}], id <{}> on server cluster: {}", new Object[]{input.getName(), input.getId(), e});
            return;
        }
        LOG.info("Unregistered input [{}], id <{}> on server cluster.", (Object)input.getName(), (Object)input.getId());
        this.inputRegistry.remove(state);
    }
}

