/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio.cluster;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Request;
import com.ning.http.client.Response;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.UriBuilder;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.radio.inputs.api.InputSummaryResponse;
import org.graylog2.radio.inputs.api.PersistedInputsResponse;
import org.graylog2.radio.inputs.api.RegisterInputResponse;
import org.graylog2.shared.rest.resources.system.inputs.requests.RegisterInputRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputService {
    private static final Logger LOG = LoggerFactory.getLogger(InputService.class);
    protected final ObjectMapper mapper = new ObjectMapper();
    protected final AsyncHttpClient httpclient;
    protected final URI serverUrl;
    private final ServerStatus serverStatus;

    @Inject
    public InputService(AsyncHttpClient httpclient, @Named(value="graylog2_server_uri") URI serverUrl, ServerStatus serverStatus) {
        this.httpclient = httpclient;
        this.serverUrl = serverUrl;
        this.serverStatus = serverStatus;
    }

    public List<InputSummaryResponse> getPersistedInputs() throws IOException {
        Response r;
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.serverUrl);
        uriBuilder.path("/system/radios/" + this.serverStatus.getNodeId().toString() + "/inputs");
        Request request = this.httpclient.prepareGet(uriBuilder.build(new Object[0]).toString()).setHeader("Content-Type", "application/json").build();
        LOG.debug("API Request {} {}", (Object)request.getMethod(), (Object)request.getUrl());
        ListenableFuture f = this.httpclient.executeRequest(request);
        try {
            r = (Response)f.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Unable to fetch inputs from master: ", (Throwable)e);
            return Collections.emptyList();
        }
        if (r.getStatusCode() != 200) {
            throw new RuntimeException("Expected HTTP response [200] for list of persisted input but got [" + r.getStatusCode() + "].");
        }
        String responseBody = r.getResponseBody();
        PersistedInputsResponse persistedInputsResponse = (PersistedInputsResponse)this.mapper.readValue(responseBody, PersistedInputsResponse.class);
        return persistedInputsResponse.inputs;
    }

    public InputSummaryResponse getPersistedInput(String inputId) throws IOException {
        for (InputSummaryResponse inputSummaryResponse : this.getPersistedInputs()) {
            if (!inputSummaryResponse.id.equals(inputId)) continue;
            return inputSummaryResponse;
        }
        return null;
    }

    public RegisterInputResponse registerInCluster(MessageInput input) throws ExecutionException, InterruptedException, IOException {
        String json;
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.serverUrl);
        uriBuilder.path("/system/radios/" + this.serverStatus.getNodeId().toString() + "/inputs");
        RegisterInputRequest rir = RegisterInputRequest.create((MessageInput)input, (String)this.serverStatus.getNodeId().toString());
        try {
            json = this.mapper.writeValueAsString((Object)rir);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create JSON for register input request.", e);
        }
        ListenableFuture f = this.httpclient.preparePost(uriBuilder.build(new Object[0]).toString()).setHeader("Content-Type", "application/json").setBody(json).execute();
        Response r = (Response)f.get();
        RegisterInputResponse response = (RegisterInputResponse)this.mapper.readValue(r.getResponseBody(), RegisterInputResponse.class);
        input.setPersistId(response.persistId);
        if (r.getStatusCode() != 201) {
            throw new RuntimeException("Expected HTTP response [201] for input registration but got [" + r.getStatusCode() + "].");
        }
        return response;
    }

    public void unregisterInCluster(MessageInput input) throws ExecutionException, InterruptedException, IOException {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.serverUrl);
        uriBuilder.path("/system/radios/" + this.serverStatus.getNodeId().toString() + "/inputs/" + input.getPersistId());
        ListenableFuture f = this.httpclient.prepareDelete(uriBuilder.build(new Object[0]).toString()).setHeader("Content-Type", "application/json").execute();
        Response r = (Response)f.get();
        if (r.getStatusCode() != 204) {
            throw new RuntimeException("Expected HTTP response [204] for input unregistration but got [" + r.getStatusCode() + "].");
        }
    }
}

