/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio.bindings;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import com.ning.http.client.AsyncHttpClient;
import java.io.File;
import java.lang.annotation.Annotation;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.ext.ExceptionMapper;
import org.graylog2.jersey.container.netty.SecurityContextFactory;
import org.graylog2.plugin.BaseConfiguration;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.radio.Configuration;
import org.graylog2.radio.bindings.providers.AsyncHttpClientProvider;
import org.graylog2.radio.bindings.providers.RadioTransportProvider;
import org.graylog2.radio.buffers.processors.RadioProcessBufferProcessor;
import org.graylog2.radio.inputs.InputStateListener;
import org.graylog2.radio.inputs.PersistedInputsImpl;
import org.graylog2.radio.system.activities.NullActivityWriter;
import org.graylog2.radio.transports.RadioTransport;
import org.graylog2.radio.users.NullUserServiceImpl;
import org.graylog2.shared.buffers.processors.ProcessBufferProcessor;
import org.graylog2.shared.inputs.PersistedInputs;
import org.graylog2.shared.journal.NoopJournalModule;
import org.graylog2.shared.security.ShiroSecurityBinding;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.graylog2.shared.users.UserService;

public class RadioBindings
extends AbstractModule {
    private final Configuration configuration;

    public RadioBindings(Configuration configuration) {
        this.configuration = configuration;
    }

    protected void configure() {
        this.bindProviders();
        this.bindSingletons();
        this.bindTransport();
        this.bind(ProcessBufferProcessor.class).to(RadioProcessBufferProcessor.class);
        Object instance = null;
        this.bind(SecurityContextFactory.class).toProvider(Providers.of(instance));
        this.bindDynamicFeatures();
        this.bindContainerResponseFilters();
        this.bindExceptionMappers();
        this.bindInterfaces();
        this.bindEventBusListeners();
    }

    private void bindInterfaces() {
        this.bind(ActivityWriter.class).to(NullActivityWriter.class);
        this.bind(PersistedInputs.class).to(PersistedInputsImpl.class);
        this.bind(UserService.class).to(NullUserServiceImpl.class);
    }

    private void bindEventBusListeners() {
        this.bind(InputStateListener.class).asEagerSingleton();
    }

    private void bindSingletons() {
        this.bind(Configuration.class).toInstance((Object)this.configuration);
        this.bind(BaseConfiguration.class).toInstance((Object)this.configuration);
        Multibinder capabilityBinder = Multibinder.newSetBinder((Binder)this.binder(), ServerStatus.Capability.class);
        capabilityBinder.addBinding().toInstance((Object)ServerStatus.Capability.RADIO);
        this.bind(ServerStatus.class).in(Scopes.SINGLETON);
        this.install((Module)new NoopJournalModule());
        this.bind(File.class).annotatedWith((Annotation)Names.named((String)"message_journal_dir")).toProvider(Providers.of(null));
        this.bind(String[].class).annotatedWith((Annotation)Names.named((String)"RestControllerPackages")).toInstance((Object)new String[]{"org.graylog2.radio.rest.resources", "org.graylog2.shared.rest.resources"});
    }

    private void bindProviders() {
        this.bind(AsyncHttpClient.class).toProvider(AsyncHttpClientProvider.class);
    }

    private void bindTransport() {
        this.bind(RadioTransport.class).toProvider(RadioTransportProvider.class);
    }

    private void bindDynamicFeatures() {
        TypeLiteral<Class<? extends DynamicFeature>> type = new TypeLiteral<Class<? extends DynamicFeature>>(){};
        Multibinder setBinder = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)type);
        setBinder.addBinding().toInstance(ShiroSecurityBinding.class);
    }

    private void bindContainerResponseFilters() {
        TypeLiteral<Class<? extends ContainerResponseFilter>> type = new TypeLiteral<Class<? extends ContainerResponseFilter>>(){};
        Multibinder setBinder = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)type);
    }

    private void bindExceptionMappers() {
        TypeLiteral<Class<? extends ExceptionMapper>> type = new TypeLiteral<Class<? extends ExceptionMapper>>(){};
        Multibinder setBinder = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)type);
    }
}

