/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.validators.InetPortValidator;
import com.github.joschi.jadconfig.validators.PositiveIntegerValidator;
import java.net.URI;
import org.graylog2.plugin.BaseConfiguration;
import org.graylog2.plugin.Tools;

public class Configuration
extends BaseConfiguration {
    private static final int RADIO_DEFAULT_PORT = 12950;
    @Parameter(value="node_id_file")
    private String nodeIdFile = "/etc/graylog2-radio-node-id";
    @Parameter(value="transport_type", required=true)
    private String transportType = "amqp";
    @Parameter(value="rest_listen_uri", required=true)
    private URI restListenUri = URI.create("http://127.0.0.1:12950/");
    @Parameter(value="graylog2_server_uri", required=true)
    private URI graylog2ServerUri;
    @Parameter(value="kafka_brokers")
    private String kafkaBrokers;
    @Parameter(value="kafka_required_acks")
    private int kafkaRequiredAcks = 1;
    @Parameter(value="kafka_producer_type")
    private String kafkaProducerType = "async";
    @Parameter(value="kafka_batch_size", validator=PositiveIntegerValidator.class)
    private int kafkaBatchSize = 200;
    @Parameter(value="kafka_batch_max_wait_ms", validator=PositiveIntegerValidator.class)
    private int kafkaBatchMaxWaitMs = 250;
    @Parameter(value="amqp_broker_hostname")
    private String amqpHostname = "localhost";
    @Parameter(value="amqp_broker_port", validator=InetPortValidator.class)
    private int amqpPort = 5672;
    @Parameter(value="amqp_broker_username")
    private String amqpUsername;
    @Parameter(value="amqp_broker_password")
    private String amqpPassword;
    @Parameter(value="amqp_broker_vhost")
    private String amqpVhost = "/";
    @Parameter(value="amqp_broker_queue_name")
    private String amqpQueueName = "graylog2-radio-messages";
    @Parameter(value="amqp_broker_queue_type")
    private String amqpQueueType = "topic";
    @Parameter(value="amqp_broker_exchange_name")
    private String amqpExchangeName = "graylog2";
    @Parameter(value="amqp_broker_routing_key")
    private String amqpRoutingKey = "graylog2-radio-message";
    @Parameter(value="amqp_broker_parallel_queues")
    private int amqpParallelQueues = 1;
    @Parameter(value="amqp_persistent_messages_enabled")
    private boolean amqpPersistentMessagesEnabled = false;
    @Parameter(value="ring_size", required=true, validator=PositiveIntegerValidator.class)
    private int ringSize = 65536;
    @Parameter(value="radio_transport_max_errors")
    private int radioTransportMaxErrors = 0;

    public String getNodeIdFile() {
        return this.nodeIdFile;
    }

    public TRANSPORT_TYPE getTransportType() {
        try {
            return TRANSPORT_TYPE.valueOf(this.transportType.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Invalid [transport_type] configured: " + this.transportType);
        }
    }

    public URI getRestListenUri() {
        return Tools.getUriWithPort((URI)Tools.getUriWithScheme((URI)this.restListenUri, (String)this.getRestUriScheme()), (int)12900);
    }

    public URI getGraylog2ServerUri() {
        return this.graylog2ServerUri == null ? null : Tools.getUriWithPort((URI)this.graylog2ServerUri, (int)12900);
    }

    public String getKafkaBrokers() {
        return this.kafkaBrokers;
    }

    public int getKafkaRequiredAcks() {
        return this.kafkaRequiredAcks;
    }

    public String getKafkaProducerType() {
        return this.kafkaProducerType;
    }

    public int getKafkaBatchSize() {
        return this.kafkaBatchSize;
    }

    public int getKafkaBatchMaxWaitMs() {
        return this.kafkaBatchMaxWaitMs;
    }

    public String getAmqpPassword() {
        return this.amqpPassword;
    }

    public String getAmqpUsername() {
        return this.amqpUsername;
    }

    public String getAmqpVirtualHost() {
        return this.amqpVhost;
    }

    public int getAmqpPort() {
        return this.amqpPort;
    }

    public String getAmqpHostname() {
        return this.amqpHostname;
    }

    public String getAmqpQueueName() {
        return this.amqpQueueName;
    }

    public String getAmqpQueueType() {
        return this.amqpQueueType;
    }

    public String getAmqpExchangeName() {
        return this.amqpExchangeName;
    }

    public String getAmqpRoutingKey() {
        return this.amqpRoutingKey;
    }

    public int getAmqpParallelQueues() {
        return this.amqpParallelQueues;
    }

    public boolean isAmqpPersistentMessagesEnabled() {
        return this.amqpPersistentMessagesEnabled;
    }

    public int getRadioTransportMaxErrors() {
        return this.radioTransportMaxErrors;
    }

    public static enum TRANSPORT_TYPE {
        AMQP,
        KAFKA;

    }
}

