/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import com.ning.http.client.AsyncHttpClient;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.radio.Configuration;
import org.graylog2.radio.cluster.Ping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterPingPeriodical
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(MasterPingPeriodical.class);
    private final ServerStatus serverStatus;
    private final Configuration configuration;
    private final AsyncHttpClient httpClient;

    @Inject
    public MasterPingPeriodical(ServerStatus serverStatus, Configuration configuration, AsyncHttpClient httpClient) {
        this.serverStatus = serverStatus;
        this.configuration = configuration;
        this.httpClient = httpClient;
    }

    public boolean runsForever() {
        return false;
    }

    public boolean stopOnGracefulShutdown() {
        return true;
    }

    public boolean masterOnly() {
        return false;
    }

    public boolean startOnThisNode() {
        return true;
    }

    public boolean isDaemon() {
        return false;
    }

    public int getInitialDelaySeconds() {
        return 0;
    }

    public int getPeriodSeconds() {
        return 1;
    }

    public void doRun() {
        try {
            Ping.ping(this.httpClient, this.configuration.getGraylog2ServerUri(), this.configuration.getRestTransportUri(), this.serverStatus.getNodeId().toString());
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            LOG.error("Master ping failed.", (Throwable)e);
        }
    }

    protected Logger getLogger() {
        return LOG;
    }
}

