/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import scala.CountedIterator;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.GenTraversableOnce$class;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Iterator$class;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce$class;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.FlatHashTable;
import scala.collection.mutable.FlatHashTable$;
import scala.collection.mutable.HashTable$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassManifest;
import scala.runtime.BoxesRunTime;

public abstract class FlatHashTable$class {
    public static int capacity(FlatHashTable $this, int expectedSize) {
        return expectedSize == 0 ? 1 : HashTable$.MODULE$.powerOfTwo(expectedSize);
    }

    private static int initialCapacity(FlatHashTable $this) {
        return $this.capacity(FlatHashTable$.MODULE$.initialSize());
    }

    public static void init(FlatHashTable $this, ObjectInputStream in, Function1 f2) {
        in.defaultReadObject();
        $this._loadFactor_$eq(in.readInt());
        Predef$.MODULE$.assert($this._loadFactor() > 0);
        int size2 = in.readInt();
        $this.tableSize_$eq(0);
        Predef$.MODULE$.assert(size2 >= 0);
        $this.table_$eq(new Object[$this.capacity(FlatHashTable$.MODULE$.sizeForThreshold(size2, $this._loadFactor()))]);
        $this.threshold_$eq(FlatHashTable$.MODULE$.newThreshold($this._loadFactor(), Predef$.MODULE$.refArrayOps($this.table()).size()));
        boolean smDefined = in.readBoolean();
        if (smDefined) {
            $this.sizeMapInit($this.table().length);
        } else {
            $this.sizemap_$eq(null);
        }
        for (int index2 = 0; index2 < size2; ++index2) {
            Object elem2 = in.readObject();
            f2.apply(elem2);
            $this.addEntry(elem2);
        }
    }

    public static void serializeTo(FlatHashTable $this, ObjectOutputStream out$1) {
        out$1.defaultWriteObject();
        out$1.writeInt($this._loadFactor());
        out$1.writeInt($this.tableSize());
        out$1.writeBoolean($this.isSizeMapDefined());
        $this.iterator().foreach(new Serializable($this, out$1){
            public static final long serialVersionUID;
            public final ObjectOutputStream out$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Object object) {
                this.out$1.writeObject(object);
            }
            {
                this.out$1 = flatHashTable;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static Option findEntry(FlatHashTable $this, Object elem2) {
        int h = $this.index($this.elemHashCode(elem2));
        Object entry2 = $this.table()[h];
        void y1;
        void x1;
        Object object;
        Object object2;
        while (entry2 != null && !((object2 = entry2) == (object = elem2) ? true : (x1 == null ? false : (x1 instanceof Number ? BoxesRunTime.equalsNumObject((Number)x1, y1) : (x1 instanceof Character ? BoxesRunTime.equalsCharObject((Character)x1, y1) : x1.equals(y1)))))) {
            h = (h + 1) % $this.table().length;
            entry2 = $this.table()[h];
        }
        return entry2 == null ? None$.MODULE$ : new Some<Object>(entry2);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containsEntry(FlatHashTable $this, Object elem2) {
        int h = $this.index($this.elemHashCode(elem2));
        Object entry2 = $this.table()[h];
        void y1;
        void x1;
        Object object;
        Object object2;
        while (entry2 != null && !((object2 = entry2) == (object = elem2) ? true : (x1 == null ? false : (x1 instanceof Number ? BoxesRunTime.equalsNumObject((Number)x1, y1) : (x1 instanceof Character ? BoxesRunTime.equalsCharObject((Character)x1, y1) : x1.equals(y1)))))) {
            h = (h + 1) % $this.table().length;
            entry2 = $this.table()[h];
        }
        return entry2 != null;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean addEntry(FlatHashTable $this, Object elem2) {
        int h = $this.index($this.elemHashCode(elem2));
        Object entry2 = $this.table()[h];
        while (true) {
            void y1;
            void x1;
            if (entry2 == null) {
                $this.table()[h] = elem2;
                $this.tableSize_$eq($this.tableSize() + 1);
                $this.nnSizeMapAdd(h);
                if ($this.tableSize() >= $this.threshold()) {
                    FlatHashTable$class.growTable($this);
                }
                return true;
            }
            Object object = entry2;
            Object object2 = elem2;
            if (object == object2 ? true : (x1 == null ? false : (x1 instanceof Number ? BoxesRunTime.equalsNumObject((Number)x1, y1) : (x1 instanceof Character ? BoxesRunTime.equalsCharObject((Character)x1, y1) : x1.equals(y1))))) {
                return false;
            }
            h = (h + 1) % $this.table().length;
            entry2 = $this.table()[h];
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Option removeEntry(FlatHashTable $this, Object elem2) {
        int h = $this.index($this.elemHashCode(elem2));
        Object entry2 = $this.table()[h];
        while (entry2 != null) {
            void y1;
            void x1;
            Object object = entry2;
            Object object2 = elem2;
            if (object == object2 ? true : (x1 == null ? false : (x1 instanceof Number ? BoxesRunTime.equalsNumObject((Number)x1, y1) : (x1 instanceof Character ? BoxesRunTime.equalsCharObject((Character)x1, y1) : x1.equals(y1))))) {
                int h0 = h;
                int h1 = (h0 + 1) % $this.table().length;
                while (true) {
                    if ($this.table()[h1] == null) {
                        $this.table()[h0] = null;
                        $this.tableSize_$eq($this.tableSize() - 1);
                        $this.nnSizeMapRemove(h0);
                        return new Some<Object>(entry2);
                    }
                    int h2 = $this.index($this.elemHashCode($this.table()[h1]));
                    if (h2 != h1 && FlatHashTable$class.precedes$1($this, h2, h0)) {
                        $this.table()[h0] = $this.table()[h1];
                        h0 = h1;
                    }
                    h1 = (h1 + 1) % $this.table().length;
                }
            }
            h = (h + 1) % $this.table().length;
            entry2 = $this.table()[h];
        }
        return None$.MODULE$;
    }

    public static Iterator iterator(FlatHashTable $this) {
        return new Iterator<A>($this){
            private int i;
            private final FlatHashTable $outer;

            public Iterator<A> seq() {
                return Iterator$class.seq(this);
            }

            public boolean isEmpty() {
                return Iterator$class.isEmpty(this);
            }

            public boolean isTraversableAgain() {
                return Iterator$class.isTraversableAgain(this);
            }

            public boolean hasDefiniteSize() {
                return Iterator$class.hasDefiniteSize(this);
            }

            public Iterator<A> take(int n) {
                return Iterator$class.take(this, n);
            }

            public Iterator<A> drop(int n) {
                return Iterator$class.drop(this, n);
            }

            public Iterator<A> slice(int from2, int until2) {
                return Iterator$class.slice(this, from2, until2);
            }

            public <B> Iterator<B> map(Function1<A, B> f2) {
                return Iterator$class.map(this, f2);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator$class.$plus$plus(this, that);
            }

            public <B> Iterator<B> flatMap(Function1<A, GenTraversableOnce<B>> f2) {
                return Iterator$class.flatMap(this, f2);
            }

            public Iterator<A> filter(Function1<A, Object> p) {
                return Iterator$class.filter(this, p);
            }

            public Iterator<A> withFilter(Function1<A, Object> p) {
                return Iterator$class.withFilter(this, p);
            }

            public Iterator<A> filterNot(Function1<A, Object> p) {
                return Iterator$class.filterNot(this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<A, B> pf) {
                return Iterator$class.collect(this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, A, B> op) {
                return Iterator$class.scanLeft(this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<A, B, B> op) {
                return Iterator$class.scanRight(this, z, op);
            }

            public Iterator<A> takeWhile(Function1<A, Object> p) {
                return Iterator$class.takeWhile(this, p);
            }

            public Tuple2<Iterator<A>, Iterator<A>> partition(Function1<A, Object> p) {
                return Iterator$class.partition(this, p);
            }

            public Tuple2<Iterator<A>, Iterator<A>> span(Function1<A, Object> p) {
                return Iterator$class.span(this, p);
            }

            public Iterator<A> dropWhile(Function1<A, Object> p) {
                return Iterator$class.dropWhile(this, p);
            }

            public <B> Object zip(Iterator<B> that) {
                return Iterator$class.zip(this, that);
            }

            public <A1> Object padTo(int len, A1 elem2) {
                return Iterator$class.padTo(this, len, elem2);
            }

            public Iterator zipWithIndex() {
                return Iterator$class.zipWithIndex(this);
            }

            public <B, A1, B1> Object zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator$class.zipAll(this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<A, U> f2) {
                Iterator$class.foreach(this, f2);
            }

            public boolean forall(Function1<A, Object> p) {
                return Iterator$class.forall(this, p);
            }

            public boolean exists(Function1<A, Object> p) {
                return Iterator$class.exists(this, p);
            }

            public boolean contains(Object elem2) {
                return Iterator$class.contains(this, elem2);
            }

            public Option<A> find(Function1<A, Object> p) {
                return Iterator$class.find(this, p);
            }

            public int indexWhere(Function1<A, Object> p) {
                return Iterator$class.indexWhere(this, p);
            }

            public <B> int indexOf(B elem2) {
                return Iterator$class.indexOf(this, elem2);
            }

            public BufferedIterator buffered() {
                return Iterator$class.buffered(this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size2) {
                return Iterator$class.grouped(this, size2);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size2, int step) {
                return Iterator$class.sliding(this, size2, step);
            }

            public int length() {
                return Iterator$class.length(this);
            }

            public Tuple2<Iterator<A>, Iterator<A>> duplicate() {
                return Iterator$class.duplicate(this);
            }

            public <B> Object patch(int from2, Iterator<B> patchElems, int replaced) {
                return Iterator$class.patch(this, from2, patchElems, replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator$class.copyToArray(this, xs, start, len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator$class.sameElements(this, that);
            }

            public Traversable<A> toTraversable() {
                return Iterator$class.toTraversable(this);
            }

            public Iterator<A> toIterator() {
                return Iterator$class.toIterator(this);
            }

            public Stream<A> toStream() {
                return Iterator$class.toStream(this);
            }

            public String toString() {
                return Iterator$class.toString(this);
            }

            public <B> Iterator<B> append(Iterator<B> that) {
                return Iterator$class.append(this, that);
            }

            public int findIndexOf(Function1<A, Object> p) {
                return Iterator$class.findIndexOf(this, p);
            }

            public CountedIterator counted() {
                return Iterator$class.counted(this);
            }

            public <B> void readInto(Object xs, int start, int sz) {
                Iterator$class.readInto(this, xs, start, sz);
            }

            public <B> void readInto(Object xs, int start) {
                Iterator$class.readInto(this, xs, start);
            }

            public <B> void readInto(Object xs) {
                Iterator$class.readInto(this, xs);
            }

            public int sliding$default$2() {
                return Iterator$class.sliding$default$2(this);
            }

            public List<A> reversed() {
                return TraversableOnce$class.reversed(this);
            }

            public int size() {
                return TraversableOnce$class.size(this);
            }

            public boolean nonEmpty() {
                return TraversableOnce$class.nonEmpty(this);
            }

            public int count(Function1<A, Object> p) {
                return TraversableOnce$class.count(this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<A, B> pf) {
                return TraversableOnce$class.collectFirst(this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, A, B> op) {
                return (B)TraversableOnce$class.$div$colon(this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<A, B, B> op) {
                return (B)TraversableOnce$class.$colon$bslash(this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, A, B> op) {
                return (B)TraversableOnce$class.foldLeft(this, z, op);
            }

            public <B> B foldRight(B z, Function2<A, B, B> op) {
                return (B)TraversableOnce$class.foldRight(this, z, op);
            }

            public <B> B reduceLeft(Function2<B, A, B> op) {
                return (B)TraversableOnce$class.reduceLeft(this, op);
            }

            public <B> B reduceRight(Function2<A, B, B> op) {
                return (B)TraversableOnce$class.reduceRight(this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, A, B> op) {
                return TraversableOnce$class.reduceLeftOption(this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<A, B, B> op) {
                return TraversableOnce$class.reduceRightOption(this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce$class.reduce(this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce$class.reduceOption(this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce$class.fold(this, z, op);
            }

            public <B> B aggregate(B z, Function2<B, A, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce$class.aggregate(this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce$class.sum(this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce$class.product(this, num);
            }

            public <B> A min(Ordering<B> cmp) {
                return (A)TraversableOnce$class.min(this, cmp);
            }

            public <B> A max(Ordering<B> cmp) {
                return (A)TraversableOnce$class.max(this, cmp);
            }

            public <B> A maxBy(Function1<A, B> f2, Ordering<B> cmp) {
                return (A)TraversableOnce$class.maxBy(this, f2, cmp);
            }

            public <B> A minBy(Function1<A, B> f2, Ordering<B> cmp) {
                return (A)TraversableOnce$class.minBy(this, f2, cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce$class.copyToBuffer(this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce$class.copyToArray(this, xs, start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce$class.copyToArray(this, xs);
            }

            public <B> Object toArray(ClassManifest<B> evidence$1) {
                return TraversableOnce$class.toArray(this, evidence$1);
            }

            public List<A> toList() {
                return TraversableOnce$class.toList(this);
            }

            public Iterable<A> toIterable() {
                return TraversableOnce$class.toIterable(this);
            }

            public Seq<A> toSeq() {
                return TraversableOnce$class.toSeq(this);
            }

            public <B> IndexedSeq<B> toIndexedSeq() {
                return TraversableOnce$class.toIndexedSeq(this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce$class.toBuffer(this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce$class.toSet(this);
            }

            public <T, U> Map<T, U> toMap(Predef$.less.colon.less<A, Tuple2<T, U>> ev) {
                return TraversableOnce$class.toMap(this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce$class.mkString(this, start, sep, end);
            }

            public String mkString(String sep) {
                return TraversableOnce$class.mkString(this, sep);
            }

            public String mkString() {
                return TraversableOnce$class.mkString(this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce$class.addString(this, b, start, sep, end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce$class.addString(this, b, sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce$class.addString(this, b);
            }

            public <A1> A1 $div$colon$bslash(A1 z, Function2<A1, A1, A1> op) {
                return (A1)GenTraversableOnce$class.$div$colon$bslash(this, z, op);
            }

            private int i() {
                return this.i;
            }

            private void i_$eq(int n) {
                this.i = n;
            }

            public boolean hasNext() {
                while (this.i() < this.$outer.table().length && this.$outer.table()[this.i()] == null) {
                    this.i_$eq(this.i() + 1);
                }
                return this.i() < this.$outer.table().length;
            }

            public A next() {
                Object object;
                if (this.hasNext()) {
                    this.i_$eq(this.i() + 1);
                    object = this.$outer.table()[this.i() - 1];
                } else {
                    object = Iterator$.MODULE$.empty().next();
                }
                return object;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                GenTraversableOnce$class.$init$(this);
                TraversableOnce$class.$init$(this);
                Iterator$class.$init$(this);
                this.i = 0;
            }
        };
    }

    private static void growTable(FlatHashTable $this) {
        Object[] oldtable = $this.table();
        $this.table_$eq(new Object[$this.table().length * 2]);
        $this.tableSize_$eq(0);
        $this.nnSizeMapReset($this.table().length);
        $this.threshold_$eq(FlatHashTable$.MODULE$.newThreshold($this._loadFactor(), $this.table().length));
        for (int i = 0; i < oldtable.length; ++i) {
            Object entry2 = oldtable[i];
            if (entry2 == null) continue;
            $this.addEntry(entry2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void checkConsistent(FlatHashTable $this) {
        int n;
        int n2 = n = $this.table().length;
        int n3 = 0;
        Serializable serializable2 = new Serializable($this){
            public static final long serialVersionUID;
            public final FlatHashTable $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            /*
             * WARNING - void declaration
             */
            public void apply$mcVI$sp(int v1$1) {
                void message1;
                block3: {
                    block2: {
                        if (this.$outer.table()[v1$1] == null || this.$outer.containsEntry(this.$outer.table()[v1$1])) break block2;
                        Serializable serializable2 = new Serializable(this, v1$1){
                            public static final long serialVersionUID;
                            public final FlatHashTable$.anonfun.checkConsistent.1 $outer;
                            public final int v1$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return new StringBuilder().append(this.v1$1).append((Object)" ").append(this.$outer.$outer.table()[this.v1$1]).append((Object)" ").append((Object)Predef$.MODULE$.refArrayOps(this.$outer.$outer.table()).mkString()).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.v1$1 = n;
                            }
                        };
                        if (!false) break block3;
                    }
                    return;
                }
                throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)message1.apply()).toString());
            }

            public FlatHashTable scala$collection$mutable$FlatHashTable$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
        Range range2 = new Range(n3, n2, 1);
        if (range2.length() > 0) {
            void v1$12;
            void f1;
            int i1;
            void $inlThis1;
            int last1 = $inlThis1.last();
            for (i1 = $inlThis1.start(); i1 != last1; i1 += $inlThis1.step()) {
                void v1$11;
                int n4 = i1;
                if ($this.table()[n4] == null || $this.containsEntry($this.table()[v1$11]) || false) {
                    continue;
                }
                Object[] objectArray = f1.$outer.table();
                throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)new StringBuilder().append(i1).append((Object)" ").append(f1.$outer.table()[i1]).append((Object)" ").append((Object)new ArrayOps.ofRef<Object>(objectArray).mkString()).toString()).toString());
            }
            int n5 = i1;
            if ($this.table()[n5] != null && !$this.containsEntry($this.table()[v1$12]) && !false) {
                Object[] objectArray = f1.$outer.table();
                throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)new StringBuilder().append(i1).append((Object)" ").append(f1.$outer.table()[i1]).append((Object)" ").append((Object)new ArrayOps.ofRef<Object>(objectArray).mkString()).toString()).toString());
            }
        }
    }

    public static void nnSizeMapAdd(FlatHashTable $this, int h) {
        if ($this.sizemap() != null) {
            int p = h >> $this.sizeMapBucketBitSize();
            int[] nArray = $this.sizemap();
            nArray[p] = nArray[p] + 1;
        }
    }

    public static void nnSizeMapRemove(FlatHashTable $this, int h) {
        if ($this.sizemap() != null) {
            int[] nArray = $this.sizemap();
            int n = h >> $this.sizeMapBucketBitSize();
            nArray[n] = nArray[n] - 1;
        }
    }

    public static void nnSizeMapReset(FlatHashTable $this, int tableLength) {
        if ($this.sizemap() != null) {
            int nsize = $this.calcSizeMapSize(tableLength);
            if ($this.sizemap().length != nsize) {
                $this.sizemap_$eq(new int[nsize]);
            } else {
                Arrays.fill($this.sizemap(), 0);
            }
        }
    }

    public static final int totalSizeMapBuckets(FlatHashTable $this) {
        return ($this.table().length - 1) / $this.sizeMapBucketSize() + 1;
    }

    public static int calcSizeMapSize(FlatHashTable $this, int tableLength) {
        return (tableLength >> $this.sizeMapBucketBitSize()) + 1;
    }

    public static void sizeMapInit(FlatHashTable $this, int tableLength) {
        $this.sizemap_$eq(new int[$this.calcSizeMapSize(tableLength)]);
    }

    public static void sizeMapInitAndRebuild(FlatHashTable $this) {
        $this.sizeMapInit($this.table().length);
        int totalbuckets = $this.totalSizeMapBuckets();
        int tableidx = 0;
        Object[] tbl = $this.table();
        int tableuntil = Predef$.MODULE$.intWrapper($this.sizeMapBucketSize()).min(tbl.length);
        for (int bucketidx = 0; bucketidx < totalbuckets; ++bucketidx) {
            int currbucketsz = 0;
            while (tableidx < tableuntil) {
                if (tbl[tableidx] != null) {
                    ++currbucketsz;
                }
                ++tableidx;
            }
            $this.sizemap()[bucketidx] = currbucketsz;
            tableuntil += $this.sizeMapBucketSize();
        }
    }

    public static void printSizeMap(FlatHashTable $this) {
        Predef$.MODULE$.println(Predef$.MODULE$.intArrayOps($this.sizemap()).mkString("szmap: [", ", ", "]"));
    }

    public static void sizeMapDisable(FlatHashTable $this) {
        $this.sizemap_$eq(null);
    }

    public static boolean isSizeMapDefined(FlatHashTable $this) {
        return $this.sizemap() != null;
    }

    public static boolean alwaysInitSizeMap(FlatHashTable $this) {
        return false;
    }

    public static final int index(FlatHashTable $this, int hcode) {
        int improved = $this.improve(hcode);
        int ones = $this.table().length - 1;
        return improved >>> 32 - Integer.bitCount(ones) & ones;
    }

    public static void clearTable(FlatHashTable $this) {
        for (int i = $this.table().length - 1; i >= 0; --i) {
            $this.table()[i] = null;
        }
        $this.tableSize_$eq(0);
        $this.nnSizeMapReset($this.table().length);
    }

    public static FlatHashTable.Contents hashTableContents(FlatHashTable $this) {
        return new FlatHashTable.Contents($this._loadFactor(), $this.table(), $this.tableSize(), $this.threshold(), $this.sizemap());
    }

    public static void initWithContents(FlatHashTable $this, FlatHashTable.Contents c) {
        if (c != null) {
            $this._loadFactor_$eq(c.loadFactor());
            $this.table_$eq(c.table());
            $this.tableSize_$eq(c.tableSize());
            $this.threshold_$eq(c.threshold());
            $this.sizemap_$eq(c.sizemap());
        }
        if ($this.alwaysInitSizeMap() && $this.sizemap() == null) {
            $this.sizeMapInitAndRebuild();
        }
    }

    private static final boolean precedes$1(FlatHashTable $this, int i, int j) {
        int d = $this.table().length >> 1;
        return i <= j ? j - i < d : i - j > d;
    }

    public static void $init$(FlatHashTable $this) {
        $this._loadFactor_$eq(FlatHashTable$.MODULE$.defaultLoadFactor());
        $this.table_$eq(new Object[FlatHashTable$class.initialCapacity($this)]);
        $this.tableSize_$eq(0);
        $this.threshold_$eq(FlatHashTable$.MODULE$.newThreshold($this._loadFactor(), FlatHashTable$class.initialCapacity($this)));
        $this.sizemap_$eq(null);
    }
}

