/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.vfs;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import org.reflections.ReflectionsException;
import org.reflections.vfs.JarInputFile;
import org.reflections.vfs.Vfs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarInputDir
implements Vfs.Dir {
    private final URL url;
    JarInputStream jarInputStream;
    long cursor = 0L;
    long nextCursor = 0L;

    public JarInputDir(URL url) {
        this.url = url;
    }

    @Override
    public String getPath() {
        return this.url.getPath();
    }

    @Override
    public Iterable<Vfs.File> getFiles() {
        return new Iterable<Vfs.File>(){

            @Override
            public Iterator<Vfs.File> iterator() {
                return new AbstractIterator<Vfs.File>(){
                    {
                        try {
                            JarInputDir.this.jarInputStream = new JarInputStream(JarInputDir.this.url.openConnection().getInputStream());
                        }
                        catch (Exception e) {
                            throw new ReflectionsException("Could not open url connection", e);
                        }
                    }

                    @Override
                    protected Vfs.File computeNext() {
                        try {
                            ZipEntry entry2;
                            do {
                                if ((entry2 = JarInputDir.this.jarInputStream.getNextEntry()) == null) {
                                    return (Vfs.File)this.endOfData();
                                }
                                JarInputDir.this.nextCursor += entry2.getSize();
                            } while (entry2.isDirectory());
                            return new JarInputFile(entry2, JarInputDir.this, JarInputDir.this.cursor, JarInputDir.this.nextCursor);
                        }
                        catch (IOException e) {
                            throw new ReflectionsException("could not get next zip entry", e);
                        }
                    }
                };
            }
        };
    }

    @Override
    public void close() {
    }
}

