/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Sets;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.reflections.adapters.JavaReflectionAdapter;
import org.reflections.adapters.JavassistAdapter;
import org.reflections.adapters.MetadataAdapter;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.serializers.Serializer;
import org.reflections.serializers.XmlSerializer;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.FilterBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationBuilder
implements Configuration {
    @Nonnull
    private Set<Scanner> scanners = Sets.newHashSet(new TypeAnnotationsScanner(), new SubTypesScanner());
    @Nonnull
    private Set<URL> urls = Sets.newHashSet();
    protected MetadataAdapter metadataAdapter;
    @Nullable
    private Predicate<? super String> inputsFilter;
    private Serializer serializer;
    @Nullable
    private ExecutorService executorService;
    @Nullable
    private ClassLoader[] classLoaders;

    /*
     * WARNING - void declaration
     */
    public static ConfigurationBuilder build(Object ... params) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ArrayList<Object> parameters = Lists.newArrayList();
        if (params != null) {
            void var5_7;
            Object[] arr$ = params;
            int len$ = arr$.length;
            boolean bl = false;
            while (var5_7 < len$) {
                Object param2 = arr$[var5_7];
                if (param2 != null) {
                    if (param2.getClass().isArray()) {
                        for (Object p : (Object[])param2) {
                            if (p == null) continue;
                            parameters.add(p);
                        }
                    } else if (param2 instanceof Iterable) {
                        for (Object p : (Iterable)param2) {
                            if (p == null) continue;
                            parameters.add(p);
                        }
                    } else {
                        parameters.add(param2);
                    }
                }
                ++var5_7;
            }
        }
        ArrayList<ClassLoader> loaders = Lists.newArrayList();
        for (Object e : parameters) {
            if (!(e instanceof ClassLoader)) continue;
            loaders.add((ClassLoader)e);
        }
        ClassLoader[] classLoaders = loaders.isEmpty() ? null : loaders.toArray(new ClassLoader[loaders.size()]);
        FilterBuilder filterBuilder = new FilterBuilder();
        ArrayList<Scanner> scanners = Lists.newArrayList();
        for (Object param4 : parameters) {
            if (param4 instanceof String) {
                builder.addUrls(ClasspathHelper.forPackage((String)param4, classLoaders));
                filterBuilder.include(FilterBuilder.prefix((String)param4));
                continue;
            }
            if (param4 instanceof Class) {
                if (Scanner.class.isAssignableFrom((Class)param4)) {
                    try {
                        builder.addScanners((Scanner)((Class)param4).newInstance());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                builder.addUrls(ClasspathHelper.forClass((Class)param4, classLoaders));
                filterBuilder.includePackage((Class)param4);
                continue;
            }
            if (param4 instanceof Scanner) {
                scanners.add((Scanner)param4);
                continue;
            }
            if (param4 instanceof URL) {
                builder.addUrls((URL)param4);
                continue;
            }
            if (param4 instanceof ClassLoader) continue;
            if (param4 instanceof Predicate) {
                filterBuilder.add((Predicate)param4);
                continue;
            }
            if (param4 instanceof ExecutorService) {
                builder.setExecutorService((ExecutorService)param4);
                continue;
            }
            if (Reflections.log == null) continue;
            throw new ReflectionsException("could not use param " + param4);
        }
        if (builder.getUrls().isEmpty()) {
            builder.addUrls(ClasspathHelper.forClassLoader());
        }
        builder.filterInputsBy(filterBuilder);
        if (!scanners.isEmpty()) {
            builder.setScanners(scanners.toArray(new Scanner[scanners.size()]));
        }
        if (!loaders.isEmpty()) {
            builder.addClassLoaders(loaders);
        }
        return builder;
    }

    public Reflections build() {
        return new Reflections(this);
    }

    @Override
    public Set<Scanner> getScanners() {
        return this.scanners;
    }

    public ConfigurationBuilder setScanners(Scanner ... scanners) {
        this.scanners.clear();
        return this.addScanners(scanners);
    }

    public ConfigurationBuilder addScanners(Scanner ... scanners) {
        this.scanners.addAll(Sets.newHashSet(scanners));
        return this;
    }

    @Override
    public Set<URL> getUrls() {
        return this.urls;
    }

    public ConfigurationBuilder setUrls(Collection<URL> urls) {
        this.urls = Sets.newHashSet(urls);
        return this;
    }

    public ConfigurationBuilder setUrls(URL ... urls) {
        this.urls = Sets.newHashSet(urls);
        return this;
    }

    public ConfigurationBuilder addUrls(Collection<URL> urls) {
        this.urls.addAll(urls);
        return this;
    }

    public ConfigurationBuilder addUrls(URL ... urls) {
        this.urls.addAll(Sets.newHashSet(urls));
        return this;
    }

    @Override
    public MetadataAdapter getMetadataAdapter() {
        if (this.metadataAdapter != null) {
            return this.metadataAdapter;
        }
        try {
            this.metadataAdapter = new JavassistAdapter();
            return this.metadataAdapter;
        }
        catch (Throwable e) {
            if (Reflections.log != null) {
                Reflections.log.warn("could not create JavassistAdapter, using JavaReflectionAdapter", e);
            }
            this.metadataAdapter = new JavaReflectionAdapter();
            return this.metadataAdapter;
        }
    }

    public ConfigurationBuilder setMetadataAdapter(MetadataAdapter metadataAdapter) {
        this.metadataAdapter = metadataAdapter;
        return this;
    }

    @Override
    public boolean acceptsInput(String inputFqn) {
        return this.inputsFilter == null || this.inputsFilter.apply(inputFqn);
    }

    public ConfigurationBuilder filterInputsBy(Predicate<? super String> inputsFilter) {
        this.inputsFilter = inputsFilter;
        return this;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public ConfigurationBuilder setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public ConfigurationBuilder useParallelExecutor() {
        return this.useParallelExecutor(Runtime.getRuntime().availableProcessors());
    }

    public ConfigurationBuilder useParallelExecutor(int availableProcessors) {
        this.setExecutorService(Executors.newFixedThreadPool(availableProcessors));
        return this;
    }

    @Override
    public Serializer getSerializer() {
        return this.serializer != null ? this.serializer : (this.serializer = new XmlSerializer());
    }

    public ConfigurationBuilder setSerializer(Serializer serializer) {
        this.serializer = serializer;
        return this;
    }

    @Override
    public ClassLoader[] getClassLoaders() {
        return this.classLoaders;
    }

    public ConfigurationBuilder addClassLoader(ClassLoader classLoader) {
        return this.addClassLoaders(classLoader);
    }

    public ConfigurationBuilder addClassLoaders(ClassLoader ... classLoaders) {
        this.classLoaders = this.classLoaders == null ? classLoaders : ObjectArrays.concat(this.classLoaders, classLoaders, ClassLoader.class);
        return this;
    }

    public ConfigurationBuilder addClassLoaders(Collection<ClassLoader> classLoaders) {
        return this.addClassLoaders(classLoaders.toArray(new ClassLoader[classLoaders.size()]));
    }
}

