/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.serializers;

import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.reflections.serializers.Serializer;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.Utils;

public class XmlSerializer
implements Serializer {
    public Reflections read(InputStream inputStream) {
        Document document2;
        Reflections reflections;
        try {
            Constructor constructor = Reflections.class.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            reflections = (Reflections)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            reflections = new Reflections(new ConfigurationBuilder());
        }
        try {
            document2 = new SAXReader().read(inputStream);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
        for (Object e1 : document2.getRootElement().elements()) {
            Element index = (Element)e1;
            for (Object e2 : index.elements()) {
                Element entry2 = (Element)e2;
                Element key = entry2.element("key");
                Element values2 = entry2.element("values");
                for (Object o3 : values2.elements()) {
                    Element value2 = (Element)o3;
                    reflections.getStore().getOrCreate(index.getName()).put(key.getText(), value2.getText());
                }
            }
        }
        return reflections;
    }

    public File save(Reflections reflections, String filename) {
        File file = Utils.prepareFile(filename);
        Document document2 = this.createDocument(reflections);
        try {
            XMLWriter xmlWriter = new XMLWriter(new FileOutputStream(file), OutputFormat.createPrettyPrint());
            xmlWriter.write(document2);
            xmlWriter.close();
        }
        catch (IOException e) {
            throw new ReflectionsException("could not save to file " + filename, e);
        }
        return file;
    }

    public String toString(Reflections reflections) {
        Document document2 = this.createDocument(reflections);
        try {
            StringWriter writer = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter(writer, OutputFormat.createPrettyPrint());
            xmlWriter.write(document2);
            xmlWriter.close();
            return writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    private Document createDocument(Reflections reflections) {
        Map<String, Multimap<String, String>> map2 = reflections.getStore().getStoreMap();
        Document document2 = DocumentFactory.getInstance().createDocument();
        Element root2 = document2.addElement("Reflections");
        for (String indexName : map2.keySet()) {
            Element indexElement = root2.addElement(indexName);
            for (String key : map2.get(indexName).keySet()) {
                Element entryElement = indexElement.addElement("entry");
                entryElement.addElement("key").setText(key);
                Element valuesElement = entryElement.addElement("values");
                for (String value2 : map2.get(indexName).get(key)) {
                    valuesElement.addElement("value").setText(value2);
                }
            }
        }
        return document2;
    }
}

