/*
 * Decompiled with CFR 0.152.
 */
package org.reflections;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Collections2;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.lang.annotation.Inherited;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.reflections.ReflectionUtils;
import org.reflections.scanners.FieldAnnotationsScanner;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Store {
    private final Map<String, Multimap<String, String>> storeMap;
    private final transient boolean concurrent;
    private static final transient Supplier<List<String>> listSupplier = new Supplier<List<String>>(){

        @Override
        public List<String> get() {
            return Lists.newArrayList();
        }
    };
    private static final Predicate<String> isConstructor = new Predicate<String>(){

        @Override
        public boolean apply(@Nullable String input2) {
            return Utils.isConstructor(input2);
        }
    };

    protected Store() {
        this(false);
    }

    protected Store(boolean concurrent) {
        this.concurrent = concurrent;
        this.storeMap = new HashMap<String, Multimap<String, String>>();
    }

    protected ListMultimap<String, String> createMultimap() {
        ListMultimap<String, String> multimap = Multimaps.newListMultimap(new HashMap(), listSupplier);
        return this.concurrent ? Multimaps.synchronizedListMultimap(multimap) : multimap;
    }

    public Multimap<String, String> getOrCreate(String indexName) {
        Multimap<String, String> mmap;
        if (indexName.contains(".")) {
            indexName = indexName.substring(indexName.lastIndexOf(".") + 1);
        }
        if ((mmap = this.storeMap.get(indexName)) == null) {
            mmap = this.createMultimap();
            this.storeMap.put(indexName, mmap);
        }
        return mmap;
    }

    @Nullable
    public Multimap<String, String> get(Class<? extends Scanner> scannerClass) {
        return this.storeMap.get(scannerClass.getSimpleName());
    }

    public Set<String> get(Class<? extends Scanner> scannerClass, String ... keys) {
        HashSet<String> result2 = Sets.newHashSet();
        Multimap<String, String> map2 = this.get(scannerClass);
        if (map2 != null) {
            for (String key : keys) {
                result2.addAll(map2.get(key));
            }
        }
        return result2;
    }

    public Set<String> get(Class<? extends Scanner> scannerClass, Iterable<String> keys) {
        HashSet<String> result2 = Sets.newHashSet();
        Multimap<String, String> map2 = this.get(scannerClass);
        if (map2 != null) {
            for (String key : keys) {
                result2.addAll(map2.get(key));
            }
        }
        return result2;
    }

    public Map<String, Multimap<String, String>> getStoreMap() {
        return this.storeMap;
    }

    void merge(Store outer) {
        if (outer != null) {
            for (String indexName : outer.storeMap.keySet()) {
                this.getOrCreate(indexName).putAll(outer.storeMap.get(indexName));
            }
        }
    }

    public Integer getKeysCount() {
        Integer keys = 0;
        for (Multimap<String, String> multimap : this.storeMap.values()) {
            keys = keys + multimap.keySet().size();
        }
        return keys;
    }

    public Integer getValuesCount() {
        Integer values2 = 0;
        for (Multimap<String, String> multimap : this.storeMap.values()) {
            values2 = values2 + multimap.size();
        }
        return values2;
    }

    public Set<String> getSubTypesOf(String type) {
        HashSet<String> result2 = new HashSet<String>();
        Set<String> subTypes = this.get(SubTypesScanner.class, type);
        result2.addAll(subTypes);
        for (String subType : subTypes) {
            result2.addAll(this.getSubTypesOf(subType));
        }
        return result2;
    }

    public Set<String> getTypesAnnotatedWithDirectly(String annotation) {
        return this.get(TypeAnnotationsScanner.class, annotation);
    }

    public Set<String> getTypesAnnotatedWith(String annotation) {
        return this.getTypesAnnotatedWith(annotation, true);
    }

    public Set<String> getTypesAnnotatedWith(String annotation, boolean honorInherited) {
        HashSet<String> result2 = new HashSet<String>();
        if (this.isAnnotation(annotation)) {
            Set<String> types = this.getTypesAnnotatedWithDirectly(annotation);
            Set<String> inherited = this.getInheritedSubTypes(types, annotation, honorInherited);
            result2.addAll(inherited);
        }
        return result2;
    }

    public Set<String> getInheritedSubTypes(Iterable<String> types, String annotation, boolean honorInherited) {
        HashSet<String> result2;
        block4: {
            block3: {
                result2 = Sets.newHashSet(types);
                if (!honorInherited || !this.isInheritedAnnotation(annotation)) break block3;
                for (String type : types) {
                    if (!this.isClass(type)) continue;
                    result2.addAll(this.getSubTypesOf(type));
                }
                break block4;
            }
            if (honorInherited) break block4;
            for (String type : types) {
                if (this.isAnnotation(type)) {
                    result2.addAll(this.getTypesAnnotatedWith(type, false));
                    continue;
                }
                result2.addAll(this.getSubTypesOf(type));
            }
        }
        return result2;
    }

    public Set<String> getMethodsAnnotatedWith(String annotation) {
        return Sets.filter(this.get(MethodAnnotationsScanner.class, annotation), Predicates.not(isConstructor));
    }

    public Set<String> getFieldsAnnotatedWith(String annotation) {
        return this.get(FieldAnnotationsScanner.class, annotation);
    }

    public Set<String> getConstructorsAnnotatedWith(String annotation) {
        return Sets.filter(this.get(MethodAnnotationsScanner.class, annotation), isConstructor);
    }

    public Set<String> getResources(String key) {
        return this.get(ResourcesScanner.class, key);
    }

    public Set<String> getResources(Predicate<String> namePredicate) {
        Multimap<String, String> mmap = this.get(ResourcesScanner.class);
        if (mmap != null) {
            return this.get(ResourcesScanner.class, Collections2.filter(mmap.keySet(), namePredicate));
        }
        return Sets.newHashSet();
    }

    public Set<String> getResources(final Pattern pattern) {
        return this.getResources(new Predicate<String>(){

            @Override
            public boolean apply(String input2) {
                return pattern.matcher(input2).matches();
            }
        });
    }

    public boolean isClass(String type) {
        return !ReflectionUtils.forName(type, new ClassLoader[0]).isInterface();
    }

    public boolean isAnnotation(String typeAnnotatedWith) {
        Multimap<String, String> mmap = this.get(TypeAnnotationsScanner.class);
        return mmap != null && mmap.keySet().contains(typeAnnotatedWith);
    }

    public boolean isInheritedAnnotation(String typeAnnotatedWith) {
        Multimap<String, String> mmap = this.get(TypeAnnotationsScanner.class);
        return mmap != null && mmap.get(Inherited.class.getName()).contains(typeAnnotatedWith);
    }
}

