/*
 * Decompiled with CFR 0.152.
 */
package org.reflections;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.reflections.ReflectionsException;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectionUtils {
    public static boolean includeObject = false;
    private static List<String> primitiveNames;
    private static List<Class> primitiveTypes;
    private static List<String> primitiveDescriptors;

    public static Set<Class<?>> getAllSuperTypes(Class<?> type) {
        HashSet<Class<?>> result2 = Sets.newHashSet();
        if (type != null && (includeObject || !type.equals(Object.class))) {
            result2.add(type);
            result2.addAll(ReflectionUtils.getAllSuperTypes(type.getSuperclass()));
            for (Class<?> ifc : type.getInterfaces()) {
                result2.addAll(ReflectionUtils.getAllSuperTypes(ifc));
            }
        }
        return result2;
    }

    public static Set<Class<?>> getAllSuperTypes(Class<?> type, Predicate<? super Class<?>> ... predicates) {
        return ReflectionUtils.filter(ReflectionUtils.getAllSuperTypes(type), predicates);
    }

    public static Set<Method> getAllMethods(Class<?> type, Predicate<? super Method> ... predicates) {
        HashSet<Method> result2 = Sets.newHashSet();
        for (Class<?> t : ReflectionUtils.getAllSuperTypes(type)) {
            result2.addAll(ReflectionUtils.getMethods(t, predicates));
        }
        return result2;
    }

    public static Set<Method> getMethods(Class<?> t, Predicate<? super Method> ... predicates) {
        return ReflectionUtils.filter(t.isInterface() ? t.getMethods() : t.getDeclaredMethods(), predicates);
    }

    public static Set<Constructor> getAllConstructors(Class<?> type, Predicate<? super Constructor> ... predicates) {
        HashSet<Constructor> result2 = Sets.newHashSet();
        for (Class<?> t : ReflectionUtils.getAllSuperTypes(type)) {
            result2.addAll(ReflectionUtils.getConstructors(t, predicates));
        }
        return result2;
    }

    public static Set<Constructor> getConstructors(Class<?> t, Predicate<? super Constructor> ... predicates) {
        return ReflectionUtils.filter(t.getDeclaredConstructors(), predicates);
    }

    public static Set<Field> getAllFields(Class<?> type, Predicate<? super Field> ... predicates) {
        HashSet<Field> result2 = Sets.newHashSet();
        for (Class<?> t : ReflectionUtils.getAllSuperTypes(type)) {
            result2.addAll(ReflectionUtils.getFields(t, predicates));
        }
        return result2;
    }

    public static Set<Field> getFields(Class<?> type, Predicate<? super Field> ... predicates) {
        return ReflectionUtils.filter(type.getDeclaredFields(), predicates);
    }

    public static <T extends AnnotatedElement> Set<Annotation> getAllAnnotations(T type, Predicate<Annotation> ... predicates) {
        HashSet<Annotation> result2 = Sets.newHashSet();
        if (type instanceof Class) {
            for (Class<?> t : ReflectionUtils.getAllSuperTypes((Class)type)) {
                result2.addAll(ReflectionUtils.getAnnotations(t, predicates));
            }
        } else {
            result2.addAll(ReflectionUtils.getAnnotations(type, predicates));
        }
        return result2;
    }

    public static <T extends AnnotatedElement> Set<Annotation> getAnnotations(T type, Predicate<Annotation> ... predicates) {
        return ReflectionUtils.filter(type.getDeclaredAnnotations(), predicates);
    }

    public static <T extends AnnotatedElement> Set<T> getAll(Set<T> elements, Predicate<? super T> ... predicates) {
        return Utils.isEmpty(predicates) ? elements : Sets.newHashSet(Iterables.filter(elements, Predicates.and(predicates)));
    }

    public static <T extends Member> Predicate<T> withName(final String name) {
        return new Predicate<T>(){

            @Override
            public boolean apply(@Nullable T input2) {
                return input2 != null && input2.getName().equals(name);
            }
        };
    }

    public static <T extends Member> Predicate<T> withPrefix(final String prefix) {
        return new Predicate<T>(){

            @Override
            public boolean apply(@Nullable T input2) {
                return input2 != null && input2.getName().startsWith(prefix);
            }
        };
    }

    public static <T extends AnnotatedElement> Predicate<T> withPattern(final String regex) {
        return new Predicate<T>(){

            @Override
            public boolean apply(@Nullable T input2) {
                return Pattern.matches(regex, input2.toString());
            }
        };
    }

    public static <T extends AnnotatedElement> Predicate<T> withAnnotation(final Class<? extends Annotation> annotation) {
        return new Predicate<T>(){

            @Override
            public boolean apply(@Nullable T input2) {
                return input2 != null && input2.isAnnotationPresent(annotation);
            }
        };
    }

    public static <T extends AnnotatedElement> Predicate<T> withAnnotations(final Class<? extends Annotation> ... annotations) {
        return new Predicate<T>(){

            @Override
            public boolean apply(@Nullable T input2) {
                return input2 != null && Arrays.equals(annotations, input2.getAnnotations());
            }
        };
    }

    public static <T extends AnnotatedElement> Predicate<T> withAnnotation(final Annotation annotation) {
        return new Predicate<T>(){

            @Override
            public boolean apply(@Nullable T input2) {
                return input2 != null && input2.isAnnotationPresent(annotation.annotationType()) && ReflectionUtils.areAnnotationMembersMatching(input2.getAnnotation(annotation.annotationType()), annotation);
            }
        };
    }

    public static <T extends AnnotatedElement> Predicate<T> withAnnotations(final Annotation ... annotations) {
        return new Predicate<T>(){

            @Override
            public boolean apply(@Nullable T input2) {
                Annotation[] inputAnnotations;
                if (input2 != null && (inputAnnotations = input2.getAnnotations()).length == annotations.length) {
                    for (int i = 0; i < inputAnnotations.length; ++i) {
                        if (ReflectionUtils.areAnnotationMembersMatching(inputAnnotations[i], annotations[i])) continue;
                        return false;
                    }
                }
                return true;
            }
        };
    }

    public static Predicate<Member> withParameters(final Class<?> ... types) {
        return new Predicate<Member>(){

            @Override
            public boolean apply(@Nullable Member input2) {
                return Arrays.equals(ReflectionUtils.parameterTypes(input2), types);
            }
        };
    }

    public static Predicate<Member> withParametersAssignableTo(final Class ... types) {
        return new Predicate<Member>(){

            @Override
            public boolean apply(@Nullable Member input2) {
                Class[] parameterTypes;
                if (input2 != null && (parameterTypes = ReflectionUtils.parameterTypes(input2)).length == types.length) {
                    for (int i = 0; i < parameterTypes.length; ++i) {
                        if (types[i].isAssignableFrom(parameterTypes[i])) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<Member> withParametersCount(final int count2) {
        return new Predicate<Member>(){

            @Override
            public boolean apply(@Nullable Member input2) {
                return input2 != null && ReflectionUtils.parameterTypes(input2).length == count2;
            }
        };
    }

    public static Predicate<Member> withAnyParameterAnnotation(final Class<? extends Annotation> annotationClass) {
        return new Predicate<Member>(){

            @Override
            public boolean apply(@Nullable Member input2) {
                return input2 != null && Iterables.any(ReflectionUtils.parameterAnnotationTypes(input2), new Predicate<Class<? extends Annotation>>(){

                    @Override
                    public boolean apply(@Nullable Class<? extends Annotation> input2) {
                        return input2.equals(annotationClass);
                    }
                });
            }
        };
    }

    public static Predicate<Member> withAnyParameterAnnotation(final Annotation annotation) {
        return new Predicate<Member>(){

            @Override
            public boolean apply(@Nullable Member input2) {
                return input2 != null && Iterables.any(ReflectionUtils.parameterAnnotations(input2), new Predicate<Annotation>(){

                    @Override
                    public boolean apply(@Nullable Annotation input2) {
                        return ReflectionUtils.areAnnotationMembersMatching(annotation, input2);
                    }
                });
            }
        };
    }

    public static <T> Predicate<Field> withType(final Class<T> type) {
        return new Predicate<Field>(){

            @Override
            public boolean apply(@Nullable Field input2) {
                return input2 != null && input2.getType().equals(type);
            }
        };
    }

    public static <T> Predicate<Field> withTypeAssignableTo(final Class<T> type) {
        return new Predicate<Field>(){

            @Override
            public boolean apply(@Nullable Field input2) {
                return input2 != null && type.isAssignableFrom(input2.getType());
            }
        };
    }

    public static <T> Predicate<Method> withReturnType(final Class<T> type) {
        return new Predicate<Method>(){

            @Override
            public boolean apply(@Nullable Method input2) {
                return input2 != null && input2.getReturnType().equals(type);
            }
        };
    }

    public static <T> Predicate<Method> withReturnTypeAssignableTo(final Class<T> type) {
        return new Predicate<Method>(){

            @Override
            public boolean apply(@Nullable Method input2) {
                return input2 != null && type.isAssignableFrom(input2.getReturnType());
            }
        };
    }

    public static <T extends Member> Predicate<T> withModifier(final int mod) {
        return new Predicate<T>(){

            @Override
            public boolean apply(@Nullable T input2) {
                return input2 != null && (input2.getModifiers() & mod) != 0;
            }
        };
    }

    public static Class<?> forName(String typeName, ClassLoader ... classLoaders) {
        String type;
        if (ReflectionUtils.getPrimitiveNames().contains(typeName)) {
            return ReflectionUtils.getPrimitiveTypes().get(ReflectionUtils.getPrimitiveNames().indexOf(typeName));
        }
        if (typeName.contains("[")) {
            int i = typeName.indexOf("[");
            type = typeName.substring(0, i);
            String array = typeName.substring(i).replace("]", "");
            type = ReflectionUtils.getPrimitiveNames().contains(type) ? ReflectionUtils.getPrimitiveDescriptors().get(ReflectionUtils.getPrimitiveNames().indexOf(type)) : "L" + type + ";";
            type = array + type;
        } else {
            type = typeName;
        }
        for (ClassLoader classLoader : ClasspathHelper.classLoaders(classLoaders)) {
            if (type.contains("[")) {
                try {
                    return Class.forName(type, false, classLoader);
                }
                catch (Throwable ex) {
                    // empty catch block
                }
            }
            try {
                return classLoader.loadClass(type);
            }
            catch (Throwable e) {
            }
        }
        throw new ReflectionsException("could not get type for name " + typeName);
    }

    public static <T> List<Class<? extends T>> forNames(Iterable<String> classes, ClassLoader ... classLoaders) {
        ArrayList<Class<T>> result2 = new ArrayList<Class<T>>();
        for (String className : classes) {
            result2.add(ReflectionUtils.forName(className, classLoaders));
        }
        return result2;
    }

    @Nonnull
    public static List<String> names(Class<?> ... types) {
        ArrayList<String> names = new ArrayList<String>();
        if (types != null) {
            for (Class<?> type : types) {
                names.add(type.getName());
            }
        }
        return names;
    }

    public static List<String> names(Collection<Class<?>> types) {
        ArrayList<String> result2 = new ArrayList<String>(types.size());
        for (Class<?> type : types) {
            result2.add(type.getName());
        }
        return result2;
    }

    private static Class[] parameterTypes(Member member) {
        return member != null ? (member.getClass() == Method.class ? ((Method)member).getParameterTypes() : (member.getClass() == Constructor.class ? ((Constructor)member).getParameterTypes() : null)) : null;
    }

    private static Set<Annotation> parameterAnnotations(Member member) {
        Annotation[][] annotations;
        HashSet<Annotation> result2 = Sets.newHashSet();
        for (Annotation[] annotation : annotations = member instanceof Method ? ((Method)member).getParameterAnnotations() : (member instanceof Constructor ? ((Constructor)member).getParameterAnnotations() : (Annotation[][])null)) {
            Collections.addAll(result2, annotation);
        }
        return result2;
    }

    private static Set<Class<? extends Annotation>> parameterAnnotationTypes(Member member) {
        HashSet<Class<? extends Annotation>> result2 = Sets.newHashSet();
        for (Annotation annotation : ReflectionUtils.parameterAnnotations(member)) {
            result2.add(annotation.annotationType());
        }
        return result2;
    }

    private static void initPrimitives() {
        if (primitiveNames == null) {
            primitiveNames = Lists.newArrayList("boolean", "char", "byte", "short", "int", "long", "float", "double", "void");
            primitiveTypes = Lists.newArrayList(Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE);
            primitiveDescriptors = Lists.newArrayList("Z", "C", "B", "S", "I", "J", "F", "D", "V");
        }
    }

    private static List<String> getPrimitiveNames() {
        ReflectionUtils.initPrimitives();
        return primitiveNames;
    }

    private static List<Class> getPrimitiveTypes() {
        ReflectionUtils.initPrimitives();
        return primitiveTypes;
    }

    private static List<String> getPrimitiveDescriptors() {
        ReflectionUtils.initPrimitives();
        return primitiveDescriptors;
    }

    private static <T> Set<T> filter(T[] elements, Predicate<? super T> ... predicates) {
        return Utils.isEmpty(predicates) ? Sets.newHashSet(elements) : Sets.filter(Sets.newHashSet(elements), Predicates.and(predicates));
    }

    private static <T> Set<T> filter(Set<T> elements, Predicate<? super T> ... predicates) {
        return Utils.isEmpty(predicates) ? elements : Sets.filter(elements, Predicates.and(predicates));
    }

    private static boolean areAnnotationMembersMatching(Annotation annotation1, Annotation annotation2) {
        if (annotation2 != null && annotation1.annotationType() == annotation2.annotationType()) {
            for (Method method : annotation1.annotationType().getDeclaredMethods()) {
                try {
                    if (method.invoke((Object)annotation1, new Object[0]).equals(method.invoke((Object)annotation2, new Object[0]))) continue;
                    return false;
                }
                catch (Exception e) {
                    throw new ReflectionsException(String.format("could not invoke method %s on annotation %s", method.getName(), annotation1.annotationType()), e);
                }
            }
            return true;
        }
        return false;
    }
}

