/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.unpacker;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.msgpack.MessagePack;
import org.msgpack.packer.Unconverter;
import org.msgpack.template.Template;
import org.msgpack.type.Value;
import org.msgpack.unpacker.Unpacker;
import org.msgpack.unpacker.UnpackerIterator;

public abstract class AbstractUnpacker
implements Unpacker {
    protected MessagePack msgpack;
    protected int rawSizeLimit = 0x8000000;
    protected int arraySizeLimit = 0x400000;
    protected int mapSizeLimit = 0x200000;

    protected AbstractUnpacker(MessagePack msgpack) {
        this.msgpack = msgpack;
    }

    @Override
    public ByteBuffer readByteBuffer() throws IOException {
        return ByteBuffer.wrap(this.readByteArray());
    }

    @Override
    public void readArrayEnd() throws IOException {
        this.readArrayEnd(false);
    }

    @Override
    public void readMapEnd() throws IOException {
        this.readMapEnd(false);
    }

    @Override
    public UnpackerIterator iterator() {
        return new UnpackerIterator(this);
    }

    protected abstract void readValue(Unconverter var1) throws IOException;

    @Override
    public Value readValue() throws IOException {
        Unconverter uc = new Unconverter(this.msgpack);
        this.readValue(uc);
        return uc.getResult();
    }

    protected abstract boolean tryReadNil() throws IOException;

    @Override
    public <T> T read(Class<T> klass) throws IOException {
        if (this.tryReadNil()) {
            return null;
        }
        Template<Object> tmpl = this.msgpack.lookup(klass);
        return tmpl.read(this, null);
    }

    @Override
    public <T> T read(T to2) throws IOException {
        if (this.tryReadNil()) {
            return null;
        }
        Template<?> tmpl = this.msgpack.lookup(to2.getClass());
        return (T)tmpl.read(this, to2);
    }

    @Override
    public <T> T read(Template<T> tmpl) throws IOException {
        if (this.tryReadNil()) {
            return null;
        }
        return tmpl.read(this, null);
    }

    @Override
    public <T> T read(T to2, Template<T> tmpl) throws IOException {
        if (this.tryReadNil()) {
            return null;
        }
        return tmpl.read(this, to2);
    }

    @Override
    public int getReadByteCount() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void resetReadByteCount() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void setRawSizeLimit(int size2) {
        this.rawSizeLimit = size2 < 32 ? 32 : size2;
    }

    @Override
    public void setArraySizeLimit(int size2) {
        this.arraySizeLimit = size2 < 16 ? 16 : size2;
    }

    @Override
    public void setMapSizeLimit(int size2) {
        this.mapSizeLimit = size2 < 16 ? 16 : size2;
    }
}

