/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.type;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import org.msgpack.type.AbstractValue;
import org.msgpack.type.RawValue;
import org.msgpack.type.StringRawValueImpl;
import org.msgpack.type.Value;
import org.msgpack.type.ValueType;

abstract class AbstractRawValue
extends AbstractValue
implements RawValue {
    private static final char[] HEX_TABLE = "0123456789ABCDEF".toCharArray();

    AbstractRawValue() {
    }

    @Override
    public ValueType getType() {
        return ValueType.RAW;
    }

    @Override
    public boolean isRawValue() {
        return true;
    }

    @Override
    public RawValue asRawValue() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Value)) {
            return false;
        }
        Value v = (Value)o;
        if (!v.isRawValue()) {
            return false;
        }
        return Arrays.equals(this.getByteArray(), v.asRawValue().getByteArray());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getByteArray());
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        String s;
        if (this.getClass() == StringRawValueImpl.class) {
            s = this.getString();
        } else {
            CharsetDecoder decoder2 = Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.IGNORE).onUnmappableCharacter(CodingErrorAction.IGNORE);
            try {
                s = decoder2.decode(ByteBuffer.wrap(this.getByteArray())).toString();
            }
            catch (CharacterCodingException ex) {
                s = new String(this.getByteArray());
            }
        }
        sb.append("\"");
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch < ' ') {
                switch (ch) {
                    case '\n': {
                        sb.append("\\n");
                        break;
                    }
                    case '\r': {
                        sb.append("\\r");
                        break;
                    }
                    case '\t': {
                        sb.append("\\t");
                        break;
                    }
                    case '\f': {
                        sb.append("\\f");
                        break;
                    }
                    case '\b': {
                        sb.append("\\b");
                        break;
                    }
                    default: {
                        this.escapeChar(sb, ch);
                        break;
                    }
                }
                continue;
            }
            if (ch <= '\u007f') {
                switch (ch) {
                    case '\\': {
                        sb.append("\\\\");
                        break;
                    }
                    case '\"': {
                        sb.append("\\\"");
                        break;
                    }
                    default: {
                        sb.append(ch);
                        break;
                    }
                }
                continue;
            }
            if (ch >= '\ud800' && ch <= '\udfff') {
                this.escapeChar(sb, ch);
                continue;
            }
            sb.append(ch);
        }
        sb.append("\"");
        return sb;
    }

    private void escapeChar(StringBuilder sb, int ch) {
        sb.append("\\u");
        sb.append(HEX_TABLE[ch >> 12 & 0xF]);
        sb.append(HEX_TABLE[ch >> 8 & 0xF]);
        sb.append(HEX_TABLE[ch >> 4 & 0xF]);
        sb.append(HEX_TABLE[ch & 0xF]);
    }
}

