/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template.builder;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.msgpack.annotation.Beans;
import org.msgpack.annotation.Ignore;
import org.msgpack.annotation.Index;
import org.msgpack.annotation.Message;
import org.msgpack.annotation.MessagePackBeans;
import org.msgpack.annotation.MessagePackMessage;
import org.msgpack.annotation.MessagePackOrdinalEnum;
import org.msgpack.annotation.NotNullable;
import org.msgpack.annotation.Optional;
import org.msgpack.annotation.OrdinalEnum;
import org.msgpack.template.FieldList;
import org.msgpack.template.FieldOption;
import org.msgpack.template.Template;
import org.msgpack.template.TemplateRegistry;
import org.msgpack.template.builder.DefaultFieldEntry;
import org.msgpack.template.builder.FieldEntry;
import org.msgpack.template.builder.TemplateBuildException;
import org.msgpack.template.builder.TemplateBuilder;

public abstract class AbstractTemplateBuilder
implements TemplateBuilder {
    protected TemplateRegistry registry;

    protected AbstractTemplateBuilder(TemplateRegistry registry) {
        this.registry = registry;
    }

    @Override
    public <T> Template<T> buildTemplate(Type targetType) throws TemplateBuildException {
        Class targetClass = (Class)targetType;
        this.checkClassValidation(targetClass);
        FieldOption fieldOption = this.getFieldOption(targetClass);
        FieldEntry[] entries = this.toFieldEntries(targetClass, fieldOption);
        return this.buildTemplate(targetClass, entries);
    }

    @Override
    public <T> Template<T> buildTemplate(Class<T> targetClass, FieldList fieldList) throws TemplateBuildException {
        this.checkClassValidation(targetClass);
        FieldEntry[] entries = this.toFieldEntries(targetClass, fieldList);
        return this.buildTemplate(targetClass, entries);
    }

    protected abstract <T> Template<T> buildTemplate(Class<T> var1, FieldEntry[] var2);

    protected void checkClassValidation(Class<?> targetClass) {
        if (Modifier.isAbstract(targetClass.getModifiers())) {
            throw new TemplateBuildException("Cannot build template for abstract class: " + targetClass.getName());
        }
        if (targetClass.isInterface()) {
            throw new TemplateBuildException("Cannot build template for interface: " + targetClass.getName());
        }
        if (targetClass.isArray()) {
            throw new TemplateBuildException("Cannot build template for array class: " + targetClass.getName());
        }
        if (targetClass.isPrimitive()) {
            throw new TemplateBuildException("Cannot build template of primitive type: " + targetClass.getName());
        }
    }

    protected FieldOption getFieldOption(Class<?> targetClass) {
        Message m = targetClass.getAnnotation(Message.class);
        if (m == null) {
            return FieldOption.DEFAULT;
        }
        MessagePackMessage mpm = targetClass.getAnnotation(MessagePackMessage.class);
        if (mpm == null) {
            return FieldOption.DEFAULT;
        }
        return m.value();
    }

    private FieldEntry[] toFieldEntries(Class<?> targetClass, FieldList flist) {
        List<FieldList.Entry> src = flist.getList();
        FieldEntry[] entries = new FieldEntry[src.size()];
        for (int i = 0; i < src.size(); ++i) {
            FieldList.Entry s = src.get(i);
            if (s.isAvailable()) {
                try {
                    entries[i] = new DefaultFieldEntry(targetClass.getDeclaredField(s.getName()), s.getOption());
                    continue;
                }
                catch (SecurityException e) {
                    throw new TemplateBuildException(e);
                }
                catch (NoSuchFieldException e) {
                    throw new TemplateBuildException(e);
                }
            }
            entries[i] = new DefaultFieldEntry();
        }
        return entries;
    }

    protected FieldEntry[] toFieldEntries(Class<?> targetClass, FieldOption from2) {
        Field[] fields = this.getFields(targetClass);
        ArrayList<DefaultFieldEntry> indexed = new ArrayList<DefaultFieldEntry>();
        int maxIndex = -1;
        for (Field f2 : fields) {
            FieldOption opt2 = this.getFieldOption(f2, from2);
            if (opt2 == FieldOption.IGNORE) continue;
            int index = this.getFieldIndex(f2, maxIndex);
            if (indexed.size() > index && indexed.get(index) != null) {
                throw new TemplateBuildException("duplicated index: " + index);
            }
            if (index < 0) {
                throw new TemplateBuildException("invalid index: " + index);
            }
            while (indexed.size() <= index) {
                indexed.add(null);
            }
            indexed.set(index, new DefaultFieldEntry(f2, opt2));
            if (maxIndex >= index) continue;
            maxIndex = index;
        }
        FieldEntry[] entries = new FieldEntry[maxIndex + 1];
        for (int i = 0; i < indexed.size(); ++i) {
            FieldEntry e = (FieldEntry)indexed.get(i);
            entries[i] = e == null ? new DefaultFieldEntry() : e;
        }
        return entries;
    }

    private Field[] getFields(Class<?> targetClass) {
        ArrayList<Field[]> succ = new ArrayList<Field[]>();
        int total = 0;
        for (Class<?> c = targetClass; c != Object.class; c = c.getSuperclass()) {
            Field[] fields = c.getDeclaredFields();
            total += fields.length;
            succ.add(fields);
        }
        Field[] result2 = new Field[total];
        int off = 0;
        for (int i = succ.size() - 1; i >= 0; --i) {
            Field[] fields = (Field[])succ.get(i);
            System.arraycopy(fields, 0, result2, off, fields.length);
            off += fields.length;
        }
        return result2;
    }

    private FieldOption getFieldOption(Field field2, FieldOption from2) {
        int mod = field2.getModifiers();
        if (Modifier.isStatic(mod) || Modifier.isFinal(mod) || Modifier.isTransient(mod)) {
            return FieldOption.IGNORE;
        }
        if (AbstractTemplateBuilder.isAnnotated(field2, Ignore.class)) {
            return FieldOption.IGNORE;
        }
        if (AbstractTemplateBuilder.isAnnotated(field2, Optional.class)) {
            return FieldOption.OPTIONAL;
        }
        if (AbstractTemplateBuilder.isAnnotated(field2, NotNullable.class)) {
            return FieldOption.NOTNULLABLE;
        }
        if (from2 != FieldOption.DEFAULT) {
            return from2;
        }
        if (field2.getType().isPrimitive()) {
            return FieldOption.NOTNULLABLE;
        }
        return FieldOption.OPTIONAL;
    }

    private int getFieldIndex(Field field2, int maxIndex) {
        Index a = field2.getAnnotation(Index.class);
        if (a == null) {
            return maxIndex + 1;
        }
        return a.value();
    }

    @Override
    public void writeTemplate(Type targetType, String directoryName) {
        throw new UnsupportedOperationException(targetType.toString());
    }

    @Override
    public <T> Template<T> loadTemplate(Type targetType) {
        return null;
    }

    public static boolean isAnnotated(Class<?> targetClass, Class<? extends Annotation> with) {
        return targetClass.getAnnotation(with) != null;
    }

    public static boolean isAnnotated(AccessibleObject accessibleObject, Class<? extends Annotation> with) {
        return accessibleObject.getAnnotation(with) != null;
    }

    public static boolean matchAtClassTemplateBuilder(Class<?> targetClass, boolean hasAnnotation) {
        if (hasAnnotation) {
            return AbstractTemplateBuilder.isAnnotated(targetClass, Message.class) || AbstractTemplateBuilder.isAnnotated(targetClass, MessagePackMessage.class);
        }
        return !targetClass.isEnum() && !targetClass.isInterface();
    }

    public static boolean matchAtBeansClassTemplateBuilder(Type targetType, boolean hasAnnotation) {
        Class targetClass = (Class)targetType;
        if (hasAnnotation) {
            return AbstractTemplateBuilder.isAnnotated((Class)targetType, Beans.class) || AbstractTemplateBuilder.isAnnotated((Class)targetType, MessagePackBeans.class);
        }
        return !targetClass.isEnum() || !targetClass.isInterface();
    }

    public static boolean matchAtArrayTemplateBuilder(Class<?> targetClass, boolean hasAnnotation) {
        if (targetClass instanceof GenericArrayType) {
            return true;
        }
        return targetClass.isArray();
    }

    public static boolean matchAtOrdinalEnumTemplateBuilder(Class<?> targetClass, boolean hasAnnotation) {
        if (hasAnnotation) {
            return AbstractTemplateBuilder.isAnnotated(targetClass, OrdinalEnum.class) || AbstractTemplateBuilder.isAnnotated(targetClass, MessagePackOrdinalEnum.class);
        }
        return targetClass.isEnum();
    }
}

