/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.msgpack.MessageTypeException;
import org.msgpack.packer.Packer;
import org.msgpack.template.AbstractTemplate;
import org.msgpack.template.Template;
import org.msgpack.unpacker.Unpacker;

public class SetTemplate<E>
extends AbstractTemplate<Set<E>> {
    private Template<E> elementTemplate;

    public SetTemplate(Template<E> elementTemplate) {
        this.elementTemplate = elementTemplate;
    }

    @Override
    public void write(Packer pk, Set<E> target, boolean required) throws IOException {
        if (!(target instanceof Set)) {
            if (target == null) {
                if (required) {
                    throw new MessageTypeException("Attempted to write null");
                }
                pk.writeNil();
                return;
            }
            throw new MessageTypeException("Target is not a List but " + target.getClass());
        }
        pk.writeArrayBegin(target.size());
        for (E e : target) {
            this.elementTemplate.write(pk, e);
        }
        pk.writeArrayEnd();
    }

    @Override
    public Set<E> read(Unpacker u, Set<E> to2, boolean required) throws IOException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        int n = u.readArrayBegin();
        if (to2 == null) {
            to2 = new HashSet(n);
        } else {
            to2.clear();
        }
        for (int i = 0; i < n; ++i) {
            Object e = this.elementTemplate.read(u, null);
            to2.add(e);
        }
        u.readArrayEnd();
        return to2;
    }
}

