/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import org.msgpack.MessagePackable;
import org.msgpack.MessageTypeException;
import org.msgpack.packer.Packer;
import org.msgpack.template.AbstractTemplate;
import org.msgpack.unpacker.Unpacker;

public class MessagePackableTemplate
extends AbstractTemplate<MessagePackable> {
    private Class<?> targetClass;

    MessagePackableTemplate(Class<?> targetClass) {
        this.targetClass = targetClass;
    }

    @Override
    public void write(Packer pk, MessagePackable target, boolean required) throws IOException {
        if (target == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        target.writeTo(pk);
    }

    @Override
    public MessagePackable read(Unpacker u, MessagePackable to2, boolean required) throws IOException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        if (to2 == null) {
            try {
                to2 = (MessagePackable)this.targetClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new MessageTypeException(e);
            }
            catch (IllegalAccessException e) {
                throw new MessageTypeException(e);
            }
        }
        to2.readFrom(u);
        return to2;
    }
}

