/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.msgpack.MessageTypeException;
import org.msgpack.packer.Packer;
import org.msgpack.template.AbstractTemplate;
import org.msgpack.template.Template;
import org.msgpack.unpacker.Unpacker;

public class MapTemplate<K, V>
extends AbstractTemplate<Map<K, V>> {
    private Template<K> keyTemplate;
    private Template<V> valueTemplate;

    public MapTemplate(Template<K> keyTemplate, Template<V> valueTemplate) {
        this.keyTemplate = keyTemplate;
        this.valueTemplate = valueTemplate;
    }

    @Override
    public void write(Packer pk, Map<K, V> target, boolean required) throws IOException {
        if (!(target instanceof Map)) {
            if (target == null) {
                if (required) {
                    throw new MessageTypeException("Attempted to write null");
                }
                pk.writeNil();
                return;
            }
            throw new MessageTypeException("Target is not a Map but " + target.getClass());
        }
        Map<K, V> map2 = target;
        pk.writeMapBegin(map2.size());
        for (Map.Entry<K, V> pair2 : map2.entrySet()) {
            this.keyTemplate.write(pk, pair2.getKey());
            this.valueTemplate.write(pk, pair2.getValue());
        }
        pk.writeMapEnd();
    }

    @Override
    public Map<K, V> read(Unpacker u, Map<K, V> to2, boolean required) throws IOException {
        Map<K, V> map2;
        if (!required && u.trySkipNil()) {
            return null;
        }
        int n = u.readMapBegin();
        if (to2 != null) {
            map2 = to2;
            map2.clear();
        } else {
            map2 = new HashMap(n);
        }
        for (int i = 0; i < n; ++i) {
            Object key = this.keyTemplate.read(u, null);
            Object value2 = this.valueTemplate.read(u, null);
            map2.put(key, value2);
        }
        u.readMapEnd();
        return map2;
    }
}

