/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import org.msgpack.MessageTypeException;
import org.msgpack.packer.Packer;
import org.msgpack.template.AbstractTemplate;
import org.msgpack.unpacker.Unpacker;

public class DoubleArrayTemplate
extends AbstractTemplate<double[]> {
    static final DoubleArrayTemplate instance = new DoubleArrayTemplate();

    private DoubleArrayTemplate() {
    }

    @Override
    public void write(Packer pk, double[] target, boolean required) throws IOException {
        if (target == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        pk.writeArrayBegin(target.length);
        for (double a : target) {
            pk.write(a);
        }
        pk.writeArrayEnd();
    }

    @Override
    public double[] read(Unpacker u, double[] to2, boolean required) throws IOException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        int n = u.readArrayBegin();
        if (to2 == null || to2.length != n) {
            to2 = new double[n];
        }
        for (int i = 0; i < n; ++i) {
            to2[i] = u.readDouble();
        }
        u.readArrayEnd();
        return to2;
    }

    public static DoubleArrayTemplate getInstance() {
        return instance;
    }
}

