/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import org.msgpack.MessageTypeException;
import org.msgpack.packer.Packer;
import org.msgpack.template.AbstractTemplate;
import org.msgpack.unpacker.Unpacker;

public class ByteTemplate
extends AbstractTemplate<Byte> {
    static final ByteTemplate instance = new ByteTemplate();

    private ByteTemplate() {
    }

    @Override
    public void write(Packer pk, Byte target, boolean required) throws IOException {
        if (target == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        pk.write((byte)target);
    }

    @Override
    public Byte read(Unpacker u, Byte to2, boolean required) throws IOException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        return u.readByte();
    }

    public static ByteTemplate getInstance() {
        return instance;
    }
}

