/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import org.msgpack.MessageTypeException;
import org.msgpack.packer.Packer;
import org.msgpack.template.AbstractTemplate;
import org.msgpack.unpacker.Unpacker;

public class BooleanArrayTemplate
extends AbstractTemplate<boolean[]> {
    static final BooleanArrayTemplate instance = new BooleanArrayTemplate();

    private BooleanArrayTemplate() {
    }

    @Override
    public void write(Packer pk, boolean[] target, boolean required) throws IOException {
        if (target == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        pk.writeArrayBegin(target.length);
        for (boolean a : target) {
            pk.write(a);
        }
        pk.writeArrayEnd();
    }

    @Override
    public boolean[] read(Unpacker u, boolean[] to2, boolean required) throws IOException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        int n = u.readArrayBegin();
        if (to2 == null || to2.length != n) {
            to2 = new boolean[n];
        }
        for (int i = 0; i < n; ++i) {
            to2[i] = u.readBoolean();
        }
        u.readArrayEnd();
        return to2;
    }

    public static BooleanArrayTemplate getInstance() {
        return instance;
    }
}

