/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.io;

import java.util.LinkedList;
import org.msgpack.io.BufferedOutput;

public final class LinkedBufferOutput
extends BufferedOutput {
    private LinkedList<Link> link = new LinkedList();
    private int size;

    public LinkedBufferOutput(int bufferSize) {
        super(bufferSize);
    }

    public byte[] toByteArray() {
        byte[] bytes = new byte[this.size + this.filled];
        int off = 0;
        for (Link l : this.link) {
            System.arraycopy(l.buffer, l.offset, bytes, off, l.size);
            off += l.size;
        }
        if (this.filled > 0) {
            System.arraycopy(this.buffer, 0, bytes, off, this.filled);
        }
        return bytes;
    }

    public int getSize() {
        return this.size + this.filled;
    }

    @Override
    protected boolean flushBuffer(byte[] b, int off, int len) {
        this.link.add(new Link(b, off, len));
        this.size += len;
        return false;
    }

    public void clear() {
        this.link.clear();
        this.size = 0;
        this.filled = 0;
    }

    @Override
    public void close() {
    }

    private static final class Link {
        final byte[] buffer;
        final int offset;
        final int size;

        Link(byte[] buffer, int offset, int size2) {
            this.buffer = buffer;
            this.offset = offset;
            this.size = size2;
        }
    }
}

