/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ProxyCtl;
import org.glassfish.hk2.api.ServiceHandle;
import org.jvnet.hk2.internal.DelegatingClassLoader;
import org.jvnet.hk2.internal.MethodInterceptorImpl;
import org.jvnet.hk2.internal.MethodInterceptorInvocationHandler;
import org.jvnet.hk2.internal.ServiceLocatorImpl;
import org.jvnet.hk2.internal.Utilities;

public class ProxyUtilities {
    private static final Object proxyCreationLock = new Object();

    private static <T> T secureCreate(final Class<?> superclass, final Class<?>[] interfaces, final MethodHandler callback, boolean useJDKProxy) {
        final ClassLoader delegatingLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return new DelegatingClassLoader(superclass.getClassLoader(), ProxyFactory.class.getClassLoader(), ProxyCtl.class.getClassLoader());
            }
        });
        if (useJDKProxy) {
            return AccessController.doPrivileged(new PrivilegedAction<T>(){

                @Override
                public T run() {
                    return Proxy.newProxyInstance(delegatingLoader, interfaces, (InvocationHandler)new MethodInterceptorInvocationHandler(callback));
                }
            });
        }
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            /*
             * Loose catch block
             * Enabled aggressive exception aggregation
             */
            @Override
            public T run() {
                Object object = proxyCreationLock;
                synchronized (object) {
                    ProxyFactory.ClassLoaderProvider originalProvider = ProxyFactory.classLoaderProvider;
                    ProxyFactory.classLoaderProvider = new ProxyFactory.ClassLoaderProvider(){

                        @Override
                        public ClassLoader get(ProxyFactory arg0) {
                            return delegatingLoader;
                        }
                    };
                    ProxyFactory proxyFactory = new ProxyFactory();
                    proxyFactory.setInterfaces(interfaces);
                    proxyFactory.setSuperclass(superclass);
                    Class proxyClass = proxyFactory.createClass();
                    Object proxy = proxyClass.newInstance();
                    ((ProxyObject)proxy).setHandler(callback);
                    Object t = proxy;
                    return t;
                    {
                        catch (Exception e1) {
                            throw new RuntimeException(e1);
                        }
                    }
                    finally {
                        ProxyFactory.classLoaderProvider = originalProvider;
                    }
                }
            }
        });
    }

    public static <T> T generateProxy(Class<?> requestedClass, ServiceLocatorImpl locator, ActiveDescriptor<T> root2, ServiceHandle<T> handle2) {
        T proxy;
        Class[] iFaces;
        Class<?> proxyClass;
        boolean isInterface;
        boolean bl = isInterface = requestedClass == null ? false : requestedClass.isInterface();
        if (isInterface) {
            proxyClass = requestedClass;
            iFaces = new Class[]{proxyClass, ProxyCtl.class};
        } else {
            proxyClass = Utilities.getFactoryAwareImplementationClass(root2);
            iFaces = Utilities.getInterfacesForProxy(root2.getContractTypes());
        }
        try {
            proxy = ProxyUtilities.secureCreate(proxyClass, iFaces, new MethodInterceptorImpl(locator, root2, handle2), isInterface);
        }
        catch (Throwable th) {
            IllegalArgumentException addMe = new IllegalArgumentException("While attempting to create a Proxy for " + proxyClass.getName() + " in proxiable scope " + root2.getScope() + " an error occured while creating the proxy");
            if (th instanceof MultiException) {
                MultiException me = (MultiException)th;
                me.addError(addMe);
                throw me;
            }
            MultiException me = new MultiException(th);
            me.addError(addMe);
            throw me;
        }
        return proxy;
    }
}

